      program clean
      implicit none
c clean up a TS logfile 
      character*80 infile,outfile
      integer*4 i,j,npow,nlast
      character*2 ctest
      logical lembed

      real*8 pow1,ave,sdv,var
      integer num
      character*12 filen
      real*8 jd0,jd1,jda
      character*80 cline

      real*8 freq(20),per(20),amp(20),co(20),si(20),con(20)
      character*5 pow(20)

      real*8 pi
      real*8 dt,dres,dz
      real*8 dalpha,dbeta
      real*8 dper,dsigfre,dsigper,dphase
      integer nfreq

      pi=dacos(-1.d0)

      print*,'CLEAN: Clean up a TS1.1 logfile'
      print*,'       Original code by G. Foster'
      print*,'       Fortran code by M. Templeton, 2003'
      print*,''
      print*,''

      print*,'Enter input filename'
      read*,infile

      open(unit=1,file=infile,status='old',err=1)
      goto 2
1     print*,'Sorry, could not open input file!'
      stop
2     continue

      print*,'Enter output filename'
      read*,outfile

      open(unit=2,file=outfile,status='unknown',err=3)
      goto 4
3     print*,'Sorry, could not open output file!'
      stop
4     continue

      lembed=.false.
      do i=1,100000000
       read(1,100,end=999) ctest
100    format(7x,a2)
       if(ctest.eq.'PO') then
        npow=i
        lembed=.false.
       endif
       if(ctest.eq.'DC'.or.ctest.eq.'  '.or.ctest.eq.'EF') then
        if(.not.lembed) then
         lembed=.true.
         nlast=i-1
        endif
       endif
      enddo
999   continue
      if(.not.lembed) nlast=i-1
      rewind(1)
      print*,npow,nlast

      write(2,200) infile
200   format(26h*** *** *** Scanning file ,a54,/,
     1       30h   ===========================)

      do i=1,npow-1
       read(1,*)
      enddo
      read(1,101) pow1,filen,num,ave,sdv,var
101   format(11x,f11.4,6x,a12,5x,i5,5x,f11.4,5x,f11.4,5x,f11.4)
      write(2,201) pow1,filen,num,ave,sdv,var
201   format(11h       POW=,f11.4,6h File=,a12,5h NUM=,i5,5h AVE=,
     1       f11.4,5h SDV=,f11.4,5h VAR=,f11.4)

      read(1,102) jd0,jd1,jda
102   format(9x,f12.4,1x,f12.4,7x,f12.4)
      write(2,202) jd0,jd1,jda
202   format(9h      JD ,f12.4,1h-,f12.4,7h T.AVE=,f12.4)
      read(1,103) cline
103   format(a80)
      write(2,203) cline
203   format(a80)

      j=1
      do i=npow+3,nlast
       read(1,104) freq(j),per(j),pow(j),amp(j),co(j),si(j),con(j)
       write(2,204) freq(j),per(j),pow(j),amp(j),co(j),si(j),con(j)
104    format(f14.9,f12.4,5x,a5,4(f11.4))
204    format(f14.9,f12.4,5x,a5,4(f11.4))
       j=j+1
      enddo
      nfreq=j-1

    



      dt = jd1-jd0
      dres=sdv**2
      dres=dres*(dfloat(num-1)-(2.d0*pow1))
      dres=dres/(dfloat(num-1-(3*nfreq)))
      if(dres.lt.0.d0) dres=0.d0
      dres=dsqrt(dres)
      dz=2.d0/dfloat(num)
      dalpha=dres*dsqrt(dz)
      dz=6.d0/dfloat(num)
      dbeta=dres*dsqrt(dz)/dt/pi

      write(2,*)
      write(2,205) dres,dalpha,dbeta
      write(2,206)
205   format(14h\\sigma_{res} =,f10.4,13h   \\sigma_A =,f10.4,
     1       10h   \\beta =,f14.9)
206   format(11h  Frequency,20x,6hPeriod,19x,9hAmplitude,8x,5hPhase)

      dalpha=2.d0*dalpha
      dbeta=2.d0*dbeta
     
      do i=1,nfreq
       dper=1.d0/freq(i)
       dsigfre=dbeta/amp(i)
       dsigper=dsigfre*dper*dper
       if(co(i).ne.0.d0) then
        dz=-si(i)/co(i)
        dphase=datan(dz)
        dphase=dphase/2.d0/pi
       elseif(si(i).gt.0.d0) then
        dphase=-0.25d0
       else
        dphase=0.25d0
       endif
       if(co(i).lt.0.d0) dphase=dphase+0.5d0
       if(dphase.lt.0.d0) dphase=dphase+1.d0

       write(2,207)freq(i),dsigfre,dper,dsigper,amp(i),dalpha,dphase
207    format(f13.9,3h+/-,f11.9,f13.6,3h+/-,f9.6,f11.4,3h+/-,f6.4,f8.4)

      enddo




      close(1)
      close(2)
      end
