      program ts

c----------------------------------------------------------
c TS version 1.2.1 -- minor bug fix
c	-bugfix in polyfit.f: bug caused segmentation
c		faults when fitting polynomials to
c		high time resolution data (dt<0.1)
c	M. Templeton, AAVSO
c	April 15, 2005
c----------------------------------------------------------
c TS version 1.2 -- minor bug fixes
c	-Grant Foster bugfix to fft.f (May 2003)
c	-minor bugfix to statcomp (initialized dtave=0.d0)
c       -default scan ranges in dcdft.f
c
c	M. Templeton, AAVSO
c	September 8, 2003
c----------------------------------------------------------
c TS version 1.1 by G. Foster, AAVSO
c Fortran version by M. Templeton
c Copyright 2003 by AAVSO, all rights reserved.
c Redistribution without permission prohibited.

c ts is the main body of the program.  From it, all other parts of the
c program can be called.

      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

      
      character*80 fin,flog
      common/name/fin,flog

c local variables
      integer nchoice

c BEGIN MAIN

      call kopyrite
      goto 10
1     continue

c choices...
      write(6,*) '0: QUIT'
      write(6,*) '1: Load data'
      write(6,*) '2: Average data'
      write(6,*) '3: Polynomial fit'
      write(6,*) '4: Fourier analysis'
      read*,nchoice
      if(nchoice.eq.0) goto 99
      if(nchoice.eq.1) goto 10
      if(nchoice.eq.2) goto 20
      if(nchoice.eq.3) goto 30
      if(nchoice.eq.4) goto 40
      


10    write(6,*) 'Data file ='
      read*,fin
      call loadraw
      goto 1

20    call average
      goto 1

30    call polymast
      goto 1

40    call dcdft
      call statcomp
      goto 1

99    continue
      end

C-------------------------------------------------------------------------------

      subroutine average

c NOTE: the structure of this subroutine is very different than in the
c	BASIC version, but it produces nearly identical results.  The reason
c	I wrote it differently is that I couldn't get it to interface properly
c	with STATCOMP without rewriting a large amount of code.
c
c		Matthew Templeton, February 25, 2003

      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      real*8 tlosav,tupsav
      real*8 dtemp,t1,t2
      integer i,n
      character*80 rfile
      character*1 rsave
      integer nlow,nhigh,ifit

      do n=1,1000000
       tfit(n)=0.d0
       xfit(n)=0.d0
       nfit(n)=0
       sfit(n)=0.d0
      enddo
      
      write(6,*) 'Size of time slot ='
      read*,tsize
      if(tsize.le.0.d0) return
      numred=0
      tlosav=tlolim
      tupsav=tuplim
      dtemp=dt0+tlolim
      dtemp=idint((dtemp/tsize)+0.5d0)
      dtemp=(tsize*dtemp)-dt0
      t1=dtemp-(tsize/2.d0)
      t2=t1+tsize-1.d-5

      nlow=nlolim
      nhigh=nuplim

      ifit=1
10    continue
      do n=nlow,nhigh

       if(tvec(n).gt.t2) then
        t1=t1+tsize
        t2=t2+tsize
        if(nfit(ifit).eq.0) goto 10
        tfit(ifit)=tfit(ifit)/dfloat(nfit(ifit))
        xfit(ifit)=xfit(ifit)/dfloat(nfit(ifit))
        dvar=0.d0
        do i=nlow,n-1
         dvar=dvar + (xvec(i)**2)
        enddo
        dvar=dvar/dfloat(nfit(ifit))
        dvar=dvar - (xfit(ifit)**2)
        if(dvar.lt.0.d0) dvar=0.d0
        sfit(ifit)=0.d0
        if(nfit(ifit).gt.1)
     1   sfit(ifit)=dsqrt(dvar*dfloat(nfit(ifit))/dfloat(nfit(ifit)-1))

        ifit=ifit+1
        nlow=n
        goto 10
       endif
       tfit(ifit)=tfit(ifit)+tvec(n)
       xfit(ifit)=xfit(ifit)+xvec(n)
       nfit(ifit)=nfit(ifit)+1
      enddo
      tfit(ifit)=tfit(ifit)/dfloat(nfit(ifit))
      xfit(ifit)=xfit(ifit)/dfloat(nfit(ifit))
      dvar=0.d0
      do i=nlow,nhigh
       dvar=dvar + (xvec(i)**2)
      enddo
      dvar=dvar/dfloat(nfit(ifit))
      dvar=dvar - (xfit(ifit)**2)
      if(dvar.lt.0.d0) dvar=0.d0
      sfit(ifit)=0.d0
      if(nfit(ifit).gt.1)
     1 sfit(ifit)=dsqrt(dvar*dfloat(nfit(ifit))/dfloat(nfit(ifit)-1))
      numred=ifit

      tlolim=tlosav
      tuplim=tupsav
      call statcomp

      write(6,*) 'Save these results to a file? (y/n)'
      read*,rsave
      if(rsave.eq.'y'.or.rsave.eq.'Y') then
       write(6,*) 'File ='
       read*,rfile
       open(unit=4,file=rfile,status='unknown')
       do n=1,numred
        write(4,200) dt0+tfit(n),xfit(n),sfit(n),nfit(n)
       enddo
200    format(f12.4,2(1x,f10.4),1x,i4)
       close(4)
      endif


      return
      end 

C-------------------------------------------------------------------------------

      subroutine dcdft
      implicit none

c common arrays

      character*80 fin,flog,fprint
      integer iname
      common/name/fin,flog

      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local scalars
      integer magres,nchoice
      real*8 dpolyamp2,dang0,dang00,damplit,dt,dx,hifre,xlofre
      integer nj,iff,ixx,nbest,ipp
      real*8 ff,res,hiper,xloper,pper
      character*1 rfil
      character*80 rname
      real*8 avemod,varmod
      integer nb,np,nn,na
      real*8 dd
      real*8 ttl,xml,resid,residl,tt,xm,rdev
      integer n
      real*8 dtest(0:20),dres(0:20)
      integer nvariable,nvary,nlocked,nsofar,nv,nvlast,nchange
      real*8 dbpower
      integer iwhile1,iwhile2,iswap
      integer i,j

      character*3 nselect
      character*1 nselval(0:9)
      data nselval/"0","1","2","3","4","5","6","7","8","9"/

      iname=index(fin,' ')
      fprint=fin(1:iname)
      
      npoly = 0
      nbest=20
      nbrake=0
      dpolyamp2 = 0.d0
      dfouramp2 = 0.d0

      call statcomp

      dang0 = 1.d0 / dsqrt(12.d0 * dtvar) / 4.d0
      dang00 = dang0
      magres = 1
      dangcut = 0.95d0 * dang0
      damplit = idint(dfloat(mb - ma) / 2.d0) + 1.d0
      dt = (tvec(nuplim) - tvec(nlolim)) / dfloat(numact)
      if (dt .le. 0.d0) dt = 1.d0

c     request

1     write(6,*) ''
      write(6,*) 'FOURIER options:'
      write(6,*) '0: EXIT FOURIER'
      write(6,*) '1: standard scan (warning: may take awhile!)'
      write(6,*) '2: frequency range'
      write(6,*) '3: period range'
      write(6,*) '4: fit polynomial'
      write(6,*) '5: delete from table'
      write(6,*) '6: model the data'
      write(6,*) '7: SLICK spectrum'
      write(6,*) '8: CLEANest spectrum'
      write(6,*) '10: resolution magnification'

      read*,nchoice
      if(nchoice .gt. 0 .and. nchoice .lt. 11 .and. nchoice .ne. 9) then

       if(nchoice .eq. 1) goto 10
       if(nchoice .eq. 2) goto 20
       if(nchoice .eq. 3) goto 30
       if(nchoice .eq. 4) goto 40
       if(nchoice .eq. 5) goto 50
       if(nchoice .eq. 6) goto 60
       if(nchoice .eq. 7) goto 70
       if(nchoice .eq. 8) goto 80
       if(nchoice .eq. 10) goto 100

      elseif (nchoice .eq. 0) then
       return
      else
       write(6,*) 'Please select a valid option'
       goto 1  
      endif





c CASE F1

10    nfre = 1
      hifre = dfloat(numact) * dang0
      write(1,290) fprint,numact,dave,dsig,dvar
      write(1,292) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
c     call lognow
      write(1,201)
      do nj = 1 + npoly,numact
       ff = dfloat(nj) * dang0
       call fft(ff)
       if(nbrake .lt. 0) then
        call statcomp
        goto 1  
       endif
      enddo
      goto 1  






c CASE F2


20    nfre = 1
21    ndim = npoly + (2 * nfre)

      write(6,261) dfloat(ndim+1)*dang0/2.d0
      read(5,260) xlofre
      if (xlofre .eq. 0.d0) xlofre = dfloat(ndim + 1) * dang0 / 2.d0

      write(6,262) dfloat(numact)*dang0
      read(5,260) hifre
      if (hifre .eq. 0.d0) hifre = dfloat(numact)*dang0

      write(6,263) dang0
      read(5,260) res
      if (res .eq. 0.d0) res=dang0

      hiper = 0.d0
      if (xlofre .ne. 0.d0) hiper  = 1.d0 / xlofre
      xloper = 0.d0
      if (hifre  .ne. 0.d0) xloper = 1.d0 / hifre

      if (hifre .gt. xlofre) then
       write(1,290) fprint,numact,dave,dsig,dvar
       write(1,292) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
c      call lognow
       write(1,201)
       iff=idint((hifre - xlofre) / res)+1
       do ixx=1,iff
        ff=xlofre+dfloat(ixx-1)*res
        call fft(ff)
        if(nbrake .lt. 0) then
         call statcomp
         goto 1  
        endif
       enddo
      else
       ff = 1.d0 / xloper
       call fft(ff)
       dgpower(nbest) = 0.d0
       call tablit
      endif
      dfouramp2 = dpolyamp2
      goto 1  






c CASE F3


30    nfre = 1
      write(6,*) 'enter low period:'
      read*,xloper
      write(6,*) 'enter high period:'
      read*,hiper
      if(hiper .lt. 0.d0) then
       hiper = xloper
       res = 1.d0
      else
       write(6,*) 'period resolution:'
       read*,res
      endif
      hifre = 0.d0
      if (xloper .ne. 0.d0) hifre = 1.d0 / xloper
      xlofre = 0.d0
      if (hiper .ne. 0.d0) xlofre = 1.d0 / hiper
      write(1,290) fprint,numact,dave,dsig,dvar
      write(1,292) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
c     call lognow
      write(1,201)

      if (hiper .ge. (xloper + res)) then
       ipp=idint((hiper - xloper) / res)+1
       do ixx=1,ipp
        pper = xloper + (dfloat(ixx-1)*res)
        if(pper .ne. 0.d0) ff= 1.d0 / pper
        call fft(ff)
        if(nbrake .lt. 0) then
         call statcomp
         goto 1  
        endif
       enddo
      else
       ff = 1.d0 / xloper
       call fft(ff)
       dgpower(nbest) = 0.d0
       call tablit
      endif
      goto 1  






c CASE F4

40    write(6,*) 'choose a polynomial degree for Fourier analysis'
      read*,npoly
      if(npoly .lt. 0) npoly = 0
      nfre = 0
      call project
      dpolyamp2 = damp2
      dfouramp2 = damp2
      goto 1  






c CASE F5


50    call showbest
      n=0
      nbest=20
      write(6,*) 'Delete # (-1 to exit)'
      read*,nselect
      na=index(nselect,'-')
      if(na.ne.0) goto 1  
      na=index(nselect,'+')
      if(na.gt.1) nchange=-1
      if(na.eq.0) then
       nchange=0
       na=4
      endif
      do i=1,na-1
       do j=0,9
        if(nselect(i:i).eq.nselval(j)) n=((10**(i-1))*n)+j
       enddo
      enddo

      if(n.gt.0.and.n.lt.21) then
       do na=n,nbest-1
        if(nchange.lt.0) then
         dgnu(na)=0.d0
         dgper(na)=0.d0
         dgpower(na)=0.d0
        else
         dgnu(na)=dgnu(na+1)
         dgpower(na)=dgpower(na+1)
         dgper(na)=dgper(na+1)
        endif
       enddo
       dgnu(nbest)=0.d0
       dgpower(nbest)=0.d0
       dgper(nbest)=0.d0
      endif
      goto 50




c CASE F6


60    call getfreq
      write(6,*) 'save residuals? (y/n)'
      read*,rfil
      if(rfil.eq.'Y'.or.rfil.eq.'y') then
       if(rfil.eq.'Y') rfil='y'
       write(6,*) 'residuals filename:'
       read*,rname
       open(unit=9,file=rname,status='unknown')
      endif
      avemod = 0.d0
      varmod = 0.d0
c     compute coefficients
      write(6,*) 'Computing...'
      call project

      write(1,293) dfpow,fprint,numact,dave,dsig,dvar
      write(1,292) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
c     call lognow
      do np=1,npoly
       write(1,204) np,dcoef(np),dtscale
      enddo
      nb = npoly + (2 * nfre)
      do nn=1,nbias
       write(1,205) obias(nn),dcoef(nb+nn)
      enddo
      write(1,206)

      nb = npoly
      do nn=1,nfre
       nb=nb+2
       na=nb-1
       dd = dcoef(na)**2 + dcoef(nb)**2
       if(nn.gt.9) then
        write(1,207) dfre(nn),1.d0/dfre(nn),nn,dsqrt(dd),dcoef(na),
     1              dcoef(nb),dcoef(0)
       else
        write(1,277) dfre(nn),1.d0/dfre(nn),nn,dsqrt(dd),dcoef(na),
     1              dcoef(nb),dcoef(0)
       endif
      enddo
      ttl = 0.d0
      xml = 0.d0
      residl = 0.d0

c     compute and plot points
      do n=nlolim,nuplim
       if (nbrake .lt. 0) goto 1  
       if (wvec(n) .gt. 0.d0) then
        tt = tvec(n)
        dt = tt
        call smooth(dt,dx)
        xm = dx
        resid = xvec(n) - xm
        do nb=1,nbias
         if (obs(n) .eq. obias(nb)) resid = resid - dcoef(ndim2+nb)
        enddo
        if(rfil.eq.'y') then
         write(9,250) tt+dt0,resid,obs(n),xvec(n),xm
        endif
        ttl = tt
        xml = xm
        residl = resid
        avemod = avemod + resid
        varmod = varmod + (resid*resid)
       endif
      enddo
      close(9)
      avemod = avemod / dfloat(numact)
      varmod = varmod / dfloat(numact -1)
      rdev = dsqrt(varmod - avemod**2)
      goto 1  





c CASE F7


70    call getfreq
      call project
      dfouramp2 = damp2
      nfre = nfre+1
      goto 21





c CASE F8


80    call getfreq
      do n=1,nfre
       dtest(n) = 1.d0/dfre(n)
       dres(n) = (dang0 * (dtest(n)*dtest(n))) / 10.d0
       call resolve(dres(n),dtest(n))
      enddo

c     select variable periods
      write(6,*) 'enter number of variable periods: (0 for none)'
      read*,nvariable
      if(nvariable .gt. 0) then
       do ixx=1,nvariable
        nfre=nfre+1
        write(6,*) 'please enter var. per. #',ixx
        read*,dres(nfre)
       enddo
      endif
      nvary = nfre
c     get locked periods
      write(6,*) 'enter number of locked periods: (0 for none)'
      read*,nlocked
      if(nlocked .gt. 0) then
       do ixx=1,nlocked
        nfre=nfre+1
        write(6,*) 'please enter locked per. #',ixx
        read*,dtest(nfre)
        dres(nfre) = 0.d0
       enddo
      endif
      dbpower = 0.d0

c     perform multi-scan     
      write(1,*) 'MULTI: '
      call lognow
c     multi-period scan
c	compute base level
      do n=1,nfre
       dfre(n) = 1.d0 / dtest(n)
      enddo
      call project
      dbpower = dfpow
      if (dbpower .eq. 0.d0) dbpower = 1.d0
      nsofar = 0
      nv = 0
      nvlast = 0
      nchange = 0

c	refine the periods
81    continue
       if(nchange.lt.0.and.nvlast.gt.0) then
        iswap=nvlast
        nvlast=nv
        nv=iswap
       else
        if(nchange.lt.0) nvlast=nv
        nv=nv+1
        if(nv.gt.nvary) nv=1
       endif
       nchange=0

c      test higher periods
82     continue
        dtest(0) = dtest(nv) + dres(nv)
        dfre(nv) = 1.d0 / dtest(0)
        call project
        write(6,*) dtest(0),dfre(nv),dfpow
        if (dfpow.gt.dbpower) then
         dbpower = dfpow
         dtest(nv) = dtest(0)
         nchange = -1
         nsofar = -1
        else
         dfpow = 0.d0
        endif
       if(dfpow.ge.dbpower) goto 82 


       if (nchange.eq.0) then

c      test lower periods
83      continue
         dtest(0) = dtest(nv) - dres(nv)
         dfre(nv) = 1.d0 / dtest(0)
         call project
         write(6,*) dtest(0),dfre(nv),dfpow
         if(dfpow.gt.dbpower) then
          dbpower = dfpow
          dtest(nv) = dtest(0)
          nsofar = -1
          nchange = -1
         else
          dfpow = 0
         endif
        if(dfpow.ge.dbpower) goto 83

       endif
       dfre(nv) = 1.d0 / dtest(nv)
       do n=1,nfre
        write(1,208) dtest(n)
       enddo
       write(1,208) dbpower
       nsofar = nsofar + 1
       write(6,*) dbpower,nsofar
      if(nsofar.lt.nvary) goto 81

c     save best set to table
      dlpower = dbpower
      do n=1,nfre
       dlper = dtest(n)
       dlnu = 1.d0 / dlper
       call tablit
      enddo
      goto 1  


c CASE F10


100   write(6,*) 'enter resolution magnification:'
      read*,magres
      if(magres.ge.1.d-2.and.magres.le.1.d+2) dang0 = dang00 / magres
      goto 1  



c--------------------------------------------------------------------------
c modifying format statements to make the *.ts readable by G.Foster's CLEAN
c and AMP DOS programs.  Don't use 200 & 203, use 290 & 293 with 292,
c and don't call lognow!
c--------------------------------------------------------------------------
200   format('       DCDFT ')
201   format('     Frequency     Period      Power  Amplitude')
202   format('      cos        sin       const')
203   format('       POW=',f10.4,' ')
204   format(i2,2(1x,f10.5))
205   format(a4,1x,f10.4)
206   format('     Frequency     Period      Power  Amplitude',
     1'      cos        sin       const')
207   format(f14.9,f12.4,5x,'Fre',i2,4(1x,f10.4))
277   format(f14.9,f12.4,5x,'Fre0',i1,4(1x,f10.4))
208   format(f10.4)
250   format(f12.4,1x,f10.4,1x,a4,2(1x,f10.4))

290   format('       DCDFT File=',a13,'NUM=',i5,' AVE=',f11.4,' SDV=',
     1 f11.4,' VAR=',f11.4)
293   format('       POW=',f11.4,' File=',a13,'NUM=',i5,' AVE=',f11.4,
     1 ' SDV=',f11.4,' VAR=',f11.4)

292   format('      JD ',f12.4,'-',f12.4,' T.AVE=',f12.4)

260   format(f24.12)
261   format(22hEnter low frequency: (,f12.7,1h))
262   format(23hEnter high frequency: (,f12.7,1h))
263   format(23hFrequency resolution: (,f12.7,1h))

      end

C-------------------------------------------------------------------------------

      subroutine fft(ff)
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

      
c local scalars
      real*8 ff,pp

      integer na,nb
      real*8 dd

      if(ff.ne.0.d0) pp = 1.d0 / ff
c     print*,ff,pp
      dfre(nfre) = ff
      call project
c G. Foster bugfix, May 2003
c     write(1,200) ff,pp,dfpow,damp
      na=npoly+1
      nb=na+1
      dd=dsqrt(dcoef(na)**2 + dcoef(nb)**2)
      write(1,200) ff,pp,dfpow,dd
c end of bugfix
      if (damp .lt. dlamp .and. dlamp .ge. dllamp) call tablit
      dllamp = dlamp
      dlamp = damp
      dlnu = ff
      dlper = pp
      dlpower = dfpow
200   format(f14.9,3(1x,f10.4))
      return
      end

C-------------------------------------------------------------------------------

      subroutine getfreq
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      integer nr
      character*1 yesno

      call showbest
      nfre=0
      do nr=1,20
       if(dgpower(nr).eq.0.d0) return
10     write(6,*) 'Include period ',nr,'?'
       read*,yesno
       if(yesno.eq.'a'.or.yesno.eq.'A') goto 11
       if(yesno.eq.'y'.or.yesno.eq.'Y') then
        nfre=nfre+1
        dfre(nfre)=dgnu(nr)
       elseif(yesno.ne.'n'.and.yesno.ne.'N') then
        goto 10
       endif
      enddo
      return
11    nfre=0
      do nr=1,20
       if(dgpower(nr).eq.0.d0) return
       nfre=nfre+1
       dfre(nfre)=dgnu(nr)
      enddo
      return
      end

C-------------------------------------------------------------------------------

      subroutine kopyrite
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom


      
      nbins=20
      ma=99
      mb=-99

      write(6,*) '                                   TS v1 r2.01'
      write(6,*) '                         Time Series Analysis Program'
      write(6,*) '               (c) Copyright 1997 AAVSO; all rights re
     1served' 
      return
      end

C-------------------------------------------------------------------------------

      subroutine loadraw
      implicit none
	integer i

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

      
c local variables
      character*80 fin,flog
      common/name/fin,flog
      real*8 dtspan,x,dd,dtcorr,dx
      real*8 jda,jdb
      integer ijda,ijdb
      integer idot,ispace
      integer num,n,nxx
      real*8 deetee,deex

      idot=index(fin,'.')
      ispace=index(fin,' ')
      if(idot.eq.0) idot=ispace
      flog=fin(1:idot-1)//'.ts'
      open(unit=9,file=fin,status='old')
      open(unit=1,file=flog,status='unknown')
      
      ma=999999
      mb=-999999
      num=0
      write(6,*) 'start time = (JD 0000000)'
c     read*,ijda
      read(5,909) ijda
      write(6,*) '  end time = (JD 2500000)'
c     read*,ijdb
      read(5,909) ijdb
      if(ijdb.eq.0) ijdb=2500000
909   format(i7)
      jda=dfloat(ijda)
      jdb=dfloat(ijdb)
      do nxx=1,1000000
       read(9,*,end=99) deetee,deex
       if(deetee.lt.jda) goto 97
       if(deetee.gt.jdb) goto 99
       num=num+1
       tvec(num)=deetee
       xvec(num)=deex
       if(num.eq.1) dt0=idint(tvec(num))
       tvec(num)=tvec(num)-dt0
       wvec(num)=1.d0
       obs(num)='    '
       if(tvec(num).lt.tvec(num-1)) then
        dx=tvec(num)
        x=xvec(num)
        do n=num-1,1,-1
         if(dx.ge.tvec(n)) goto 98
         tvec(n+1)=tvec(n)
         xvec(n+1)=xvec(n)
        enddo
        n=0
98      tvec(n+1)=dx
        xvec(n+1)=x
       endif
       if(xvec(num).lt.dfloat(ma)) ma=idint(xvec(num))
       if(xvec(num).gt.dfloat(mb)) mb=idint(xvec(num))
97     continue
      enddo
99    continue
      close(9)
c     num=num-1
      ma=ma-1
      mb=mb+2
      mlow=ma
      mhigh=mb
      magspan=mhigh-mlow
      numraw=num
      if(tvec(1).lt.0.d0) then
       dx=idint(-1.d0*tvec(1))+1.d0
       dt0=dt0-dx
       do n=1,num
        tvec(n)=tvec(n)+dx
       enddo
      endif
      dtspan=tvec(numraw)
      if(dtspan.lt.1.d0) dtspan=1.d0
      x=dlog10(dtspan)
      x=idint(x-0.5d0)
      ndigt=7-int(x)
      tresolv=10.d0**x
      dd=idint(dt0/tresolv)-1.d0
      dd=dd*tresolv
      dtcorr=dt0-dd
      dt0=dd
      do n=1,numraw
       tvec(n)=tvec(n)+dtcorr
      enddo
      x=idint(tvec(numraw)/tresolv)+2.d0
      tuplimit=x*tresolv
      tlolim=0.d0
      tuplim=tuplimit
      nlolim=1
      nuplim=numraw
      tmark=0.d0
      call statcomp

      return
      end

C-------------------------------------------------------------------------------

      subroutine lognow
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

      character*80 fin,flog,fprint
      common/name/fin,flog
 
      integer iname

      iname=index(fin,' ')
      fprint='File='//fin(1:iname)

200   format(a,'NUM=',i5,' AVE=',f10.4,' SDV=',f10.4,' VAR=',f10.4)
201   format('      JD ',f12.4,'-',f12.4,' T.AVE=',f12.4)
      write(1,200) fprint,numact,dave,dsig,dvar
      write(1,201) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
      return
      end

C-------------------------------------------------------------------------------

      subroutine matinv
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      real*8 dsol(0:100,0:100),dfac
      integer ni,nj,nk


      do ni = 0,ndim
       do nj=0,ndim
        dsol(ni,nj)=0.d0
       enddo
       dsol(ni,ni) = 1.d0
      enddo

      do ni = 0,ndim
       if (dmat(ni,ni) .eq. 0.d0) then
        if (ni .eq. ndim) return
        do nj = ni+1,ndim
         if (dmat(nj,ni) .ne. 0.d0) go to 10
        enddo
        return
10      do nk = 0,ndim
         dmat(ni,nk) = dmat(ni,nk) + dmat(nj,nk)
         dsol(ni,nk) = dsol(ni,nk) + dsol(nj,nk)
        enddo
       endif 
       dfac = dmat(ni,ni)
       do nj = 0,ndim
        dmat(ni,nj) = dmat(ni,nj) / dfac
        dsol(ni,nj) = dsol(ni,nj) / dfac
       enddo
       do nj = 0,ndim
        if (nj .ne. ni) then
         dfac = dmat(nj,ni)
         do nk = 0,ndim
          dmat(nj,nk) = dmat(nj,nk) - (dmat(ni,nk)*dfac)
          dsol(nj,nk) = dsol(nj,nk) - (dsol(ni,nk)*dfac)
         enddo
        endif
       enddo
      enddo
      do ni = 0,ndim
       do nj = 0,ndim
        dmat(ni,nj) = dsol(ni,nj)
       enddo
      enddo
      return
      end

C-------------------------------------------------------------------------------

      subroutine polyfit
      implicit none

c common arrays

      character*80 fin,flog,fprint
      integer iname
      common/name/fin,flog

      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

      real*8 dzeta(0:100),d1,d2,tspan,tt,dtime,dt
      integer n1,n2,nt
      integer idtime,ntt
      real*8 x,xx,dx
      
      nfre=0
      call project
      
      do n1=0,npoly
       d1=dmat(0,n1)
       d2=dmat(npoly-n1,npoly)
       do n2=1,n1
        d1=d1+dmat(n2,n1-n2)
        d2=d2+dmat(npoly-n1+n2,npoly-n2)
       enddo
       dzeta(n1)=d1
       dzeta(2*npoly-n1)=d2
      enddo

      tspan=tvec(nuplim)-tvec(nlolim)
      nt=int(dlog10(tspan))-2
      tt=(10.d0)**nt
      numred=0
      x=tvec(nlolim)/tt
      x=tt*(int(x)+1)
      xx=tvec(nuplim)

      ntt=int((xx-x)/tt)+1

      do idtime=1,ntt
       dtime=x+dfloat(idtime-1)*tt
       call smooth(dtime,dx)
       numred=numred+1
       tfit(numred)=dtime
       xfit(numred)=dx
       dt=(dtime-dtzero)/dtscale
      enddo

      return
      end

C-------------------------------------------------------------------------------

      subroutine polymast
      implicit none

c common arrays

      character*80 fin,flog,fprint
      integer iname
      common/name/fin,flog

      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local scalars
      real*8 ds9,dcc,res,dtime,dx
      character*80 ftmp
      integer n,nb,nchoice

      iname=index(fin,' ')
      fprint=fin(1:iname)

      call statcomp
      goto 30
1     write(6,*) 'POLYNOMIAL options:'
      write(6,*) '0: EXIT POLYNOMIAL'
      write(6,*) '1: Save constants'
      write(6,*) '2: Save to file'
      write(6,*) '3: Choose degree'
      write(6,*) '4: Save residuals'

      read*,nchoice
      if(nchoice.eq.0) return
      if(nchoice.eq.1) goto 10
      if(nchoice.eq.2) goto 20
      if(nchoice.eq.3) goto 30
      if(nchoice.eq.4) goto 40
      if(nchoice.lt.0.or.nchoice.gt.4) then
       write(6,*) 'Please select a valid option'
       goto 1
      endif

10    continue
      write(1,290) fprint,numact,dave,dsig,dvar
      write(1,292) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
      write(1,211) dtzero+dt0
      write(1,212) dpower
      do n=0,npoly
       dcc=dcoef(n)/(dtscale**n)
       write(1,213) n,dcc
      enddo
      do n=1,nbias
       write(1,214) obias(n),dcoef(npoly+n)
      enddo
      goto 1

20    write(1,220) npoly
      write(1,290) fprint,numact,dave,dsig,dvar
      write(1,292) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
      write(1,221) dpower
      do n=1,numred
       write(1,222)tfit(n)+dt0,xfit(n),ds9*sfit(n)
      enddo
      goto 1

30    write(6,*) 'Polynomial degree:'
      read*,npoly
      if(npoly.lt.0.or.npoly.gt.50) then
       write(6,*) 'Degree must be greater than zero and less than 50!'
       goto 30
      endif
      call polyfit
      ds9 = dvar*( dfloat(numact-1) - dfloat(npoly)*dpower )
      ds9 = ds9 / dfloat(numact-1) / dfloat(numact-1-npoly)
      if (ds9.lt.0.d0) ds9=0.d0
      ds9=dsqrt(ds9)
      write(1,230) npoly,dpower,ds9,fprint,numact,dave,dsig,dvar
      write(1,292) dt0+tvec(nlolim),dt0+tvec(nuplim),dt0+dtzero
      goto 1

40    write(6,*) 'Residuals filename?'
      read*,ftmp
      open(unit=9,file=ftmp,status='unknown')
      do n=nlolim,nuplim
       if(wvec(n).gt.0.d0) then
        dtime=tvec(n)
        call smooth(dtime,dx)
        res=xvec(n)-dx
        do nb=1,nbias
         if(obs(n).eq.obias(nb)) res=res-dcoef(npoly+nb)
        enddo
        write(9,240) tvec(n)+dt0,res
       endif
      enddo
      close(9)
      goto 1

      return

211   format(7hTime0= ,f12.4)
212   format(7hPower= ,1pe12.6)
213   format(i2,1x,1pd24.16)
214   format(a4,1x,1pd24.16)
220   format(11hPOLY DEGREE,i2)
221   format(10h***POWER= ,1pd24.16)
222   format(f12.4,2(1x,f10.4))
230   format(4hPOLY,i2,2(1x,f10.4),1x,'File=',a13,'NUM=',i5,' AVE=',
     1 f11.4,' SDV=',f11.4,' VAR=',f11.4)
231   format(2(1x,f10.4),1x)
240   format(f12.4,1x,f10.4)



290   format('POLY COEFFICIENTS',/,'File=',a13,'NUM=',i5,' AVE=',f11.4,
     1' SDV=',f11.4,' VAR=',f11.4)
292   format('      JD ',f12.4,'-',f12.4,' T.AVE=',f12.4)

      end

C-------------------------------------------------------------------------------

      subroutine project
      implicit none


c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      real*8 dpow(0:50),drad(0:50),dcc(0:50),dss(0:50)
      real*8 dt,dx,dphase,twopi
      integer n,n1,n2,nf,nf2,nb,np

      integer ii,jj

      twopi=6.283185307179586d0

      do ii=0,50
       do jj=0,50
        dmat(ii,jj)=0.d0
       enddo
       dvec(ii)=0.d0
      enddo

      ndim2 = npoly + (2*nfre)
      ndim = ndim2 + nbias
      dweight = 0.d0

      do n1 = 0,ndim
       dvec(n1)=0.d0
       do n2 = 0,ndim
        dmat(n1,n2)=0.d0
       enddo
      enddo
      do nf = 1,nfre
       if (dfre(nf) .lt. dangcut) then
        dfpow=0.d0
        dpower=0.d0
        return
       endif
       drad(nf) = twopi * dfre(nf) * dtscale
       do nf2=nf+1,nfre
        if(dabs(dfre(nf)-dfre(nf2)) .lt. 1.d-8) then
         dpower = 0.d0
         return
        endif
       enddo
      enddo
      dpow(0) = 1.d0

c     main loop for summation
      do n = nlolim,nuplim
       if(wvec(n).gt.0.d0) then
        dweight = dweight + 1.d0
        dt = tvec(n)
        dt = (dt-dtzero)/dtscale
        dx = xvec(n)

c       compute powers of time
        do np = 1,npoly
         dpow(np) = dpow(np-1)*dt
        enddo

c       compute trig functions
        do nf = 1,nfre
         dphase = drad(nf) * dt
         dcc(nf) = dcos(dphase)
         dss(nf) = dsin(dphase)
        enddo

c       compute matrix coefficients for polynomials...
        do np = 0,npoly
         dmat(0,np) = dmat(0,np) + dpow(np)
         if (np.gt.0) then
          dmat(np,npoly) = dmat(np,npoly) + (dpow(np)*dpow(npoly))
         endif
         dvec(np) = dvec(np) + (dx * dpow(np))
         n2 = npoly
c        ...and for products of polynomials with trig functions
         do nf = 1,nfre
          n2 = n2 + 2
          dmat(np,n2-1) = dmat(np,n2-1) + (dpow(np)*dcc(nf))
          dmat(np,n2)   = dmat(np,n2)   + (dpow(np)*dss(nf))
         enddo
        enddo

c       compute matrix values for products of trig functions
        n1 = npoly
        do nf = 1,nfre
         n2 = n1
         n1 = n1 + 2
         dvec(n1-1) = dvec(n1-1) + (dx*dcc(nf))
         dvec(n1)   = dvec(n1)   + (dx*dss(nf))
         do nf2 = nf,nfre
          n2 = n2 + 2
          dmat(n1-1,n2-1) = dmat(n1-1,n2-1) + (dcc(nf)*dcc(nf2))
          dmat(n1-1,n2)   = dmat(n1-1,n2)   + (dcc(nf)*dss(nf2))
          dmat(n1,n2-1)   = dmat(n1,n2-1)   + (dss(nf)*dcc(nf2))
          dmat(n1,n2)     = dmat(n1,n2)     + (dss(nf)*dss(nf2))
         enddo
        enddo

c       compute matrix entries for observer bias functions
        do nb = 1,nbias
         if (obs(n) .eq. obias(nb)) then
          n2 = ndim2 + nb
          dmat(n2,n2) = dmat(n2,n2) + 1.d0
          dvec(n2) = dvec(n2) + dx
          do np = 0,npoly
           dmat(np,n2) = dmat(np,n2) + dpow(np)
          enddo
          n1 = npoly
          do nf = 1,nfre
           n1 = n1 + 2
           dmat(n1-1,n2) = dmat(n1-1,n2) + dcc(nf)
           dmat(n1,n2)   = dmat(n1,n2)   + dss(nf)
          enddo
         endif
        enddo

       endif

      enddo
c     end of summation loop

       

c     check for absent bias observers
      do n = 1,nbias
       if(dmat(ndim2+n,ndim2+n).lt.1.d0) then
        write(6,*) 'absent BIAS Obs: ',obias(n)
        ndim = ndim2
        nbias = 0
       endif
      enddo
      do n1 = 1,npoly-1
       do n2 = n1,npoly-1
        dmat(n1,n2) = dmat(n1-1,n2+1)
       enddo
      enddo
      do n1 = 0,ndim
       dvec(n1) = dvec(n1) / dweight
       do n2=n1,ndim
        dmat(n1,n2) = dmat(n1,n2) / dweight
       enddo
      enddo
      dmat(0,0) = 1.d0
      do n1 = 1,ndim
       do n2 = 0,n1-1
        dmat(n1,n2) = dmat(n2,n1)
       enddo
      enddo

      call matinv
      
      damp2 = 0.d0
      do n1 = 0,ndim
       dcoef(n1) = 0.d0
       do n2 = 0,ndim
        dcoef(n1) = dcoef(n1) + (dmat(n1,n2)*dvec(n2))
       enddo
       damp2 = damp2 + (dcoef(n1)*dvec(n1))
      enddo
      damp2 = damp2 - (dave*dave)
      if (damp2 .lt. 0.d0) damp2 = 0.d0
      if (ndim  .gt. 0) then
       dpower = dfloat(numact - 1)*damp2 / dvar / dfloat(ndim)
      else
       dpower = 0.d0
      endif


      
c     compute Fourier power, amplitude squared

      dfpow = dfloat(numact - 1) * (damp2 - dfouramp2)
      dfpow = dfpow / (dvar - dfouramp2) / 2.d0
      damp  = 2.d0 * (damp2 - dfouramp2)
      if (damp .lt. 0.d0) damp = 0.d0
      damp = dsqrt(damp)

      return
      end

C-------------------------------------------------------------------------------

      subroutine resolve(ddr,ddp)
      implicit none
      real*8 ddr,ddp
      integer nexp

      nexp=0
      if(ddr.eq.0.d0) return
10    if(ddr.lt.1.d0) then
       ddr=ddr*10.d0
       nexp=nexp-1
       goto 10
      else
11     if(ddr.gt.10.d0) then
        ddr=ddr/10.d0
        nexp=nexp+1
        goto 11
       endif
      endif
      if(ddr.ge.1.d0.and.ddr.lt.2.d0) ddr=1.d0
      if(ddr.ge.2.d0.and.ddr.lt.5.d0) ddr=2.d0
      if(ddr.ge.5.d0) ddr=5.d0
      ddr=ddr*(10.d0**nexp)
      ddp=ddp/ddr
      ddp=ddr*idint(ddp+0.5d0)
      return
      end

C-------------------------------------------------------------------------------

      subroutine setlimit
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      integer n

      nlolim=0
      nuplim=0
      do n=1,numraw
       if(tvec(n).ge.tlolim) goto 10
      enddo
10    nlolim=n
      do n=nlolim,numraw
       if(tvec(n).gt.tuplim) goto 11
      enddo
11    nuplim=n-1
      return
      end

C-------------------------------------------------------------------------------

      subroutine showbest
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      integer nq,j

      do nq=1,10
       write(6,100) (nq+j,dgper(nq+j),dgpower(nq+j),j=0,10,10)
100    format(2(i2,1x,f11.4,1x,f9.2,1x))
      enddo
      return
      end

C-------------------------------------------------------------------------------

      subroutine smooth(dtime,dmag)
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

      
c local variables
       real*8 dtime,dmag
       real*8 dt,dphase
       real*8 twopi
       integer np,n2,nf

       twopi=6.283185307179586d0

       dt=(dtime-dtzero)/dtscale
       dmag=dcoef(0)
       do np=1,npoly
        dmag=dmag+(dcoef(np)*(dt**np))
       enddo
       n2=npoly
       do nf=1,nfre
        n2=n2+2
        dphase=twopi*dfre(nf)*dtscale*dt
        dmag=dmag+(dcoef(n2-1)*dcos(dphase))
        dmag=dmag+(dcoef(n2)*dsin(dphase))
       enddo
       return
       end

C-------------------------------------------------------------------------------

      subroutine statcomp
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      integer n,nx
      real*8 dw,dt,dx,dtspan,xx,dts2

      call setlimit

      nbrake=0
      numact=0
      dweight=0.d0
      dave=0.d0
      dtave=0.d0
      dtvar=0.d0
      do n=nlolim,nuplim
       if (wvec(n).gt.0.d0) then
        numact=numact+1
        dw=wvec(n)
        dt=tvec(n)
        dx=xvec(n)
        dweight=dweight+dw
        dave=dave + (dw*dx)
        dvar=dvar + ((dw*dx)**2)
        dtave=dtave + dt
        dtvar=dtvar + (dt**2)
       endif
      enddo
      if (numact.lt.1) then
       dave=0.d0
       dvar=0.d0
       dsig=0.d0
       return
      endif
      dave=dave/dweight
      dvar=dvar/dweight
      dvar=dvar - (dave**2)
      if (dvar.lt.0.d0) dvar=0.d0
      dsig=0.d0
      if (numact.gt.1) dsig=dsqrt(dvar*dfloat(numact)/dfloat(numact-1))
      dtave=dtave/dfloat(numact)
      dtvar=(dtvar/dfloat(numact)) - (dtave**2)
      if (dtvar.lt.0.d0) dtvar=0.d0
      dtsig=dsqrt(dtvar)
      dtspan=tvec(nuplim) - tvec(nlolim)
      if (dtspan.le.0.d0) return
      xx=dlog10(dtspan)
      nx=idint(xx+.5d0)
      dtscale=10.d0**nx
      dts2=10.d0**(nx-3)
      dtzero=dtave/dts2
      dtzero=dts2*idint(dtzero+0.5)

      return
      end

C-------------------------------------------------------------------------------

      subroutine tablit
      implicit none

c common arrays
      real*8 tvec,xvec,wvec
      common/datapts/tvec(1000000),xvec(1000000),wvec(1000000)

      integer nfit
      real*8 tfit,xfit,sfit
      character*4 obs
      common/fitpts/tfit(1000000),xfit(1000000),sfit(1000000),
     1              nfit(1000000),obs(1000000)

      real*8 dmat,dvec,dcoef
      character*4 obias
      common/matproj/dmat(0:50,0:50),dvec(0:50),dcoef(0:50),obias(0:50)

      real*8 dgnu,dgper,dgpower,dfre
      common/fourarr/dgnu(20),dgper(20),dgpower(20),dfre(20)

c common scalars
      real*8 damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower
      real*8 dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar
      real*8 dweight,dxout
      integer nbias,nfre,npoly
      common/scalar1/damp,damp2,dangcut,dave,dfpow,dfouramp2,dpower,
     1               dt0,dtave,dtscale,dtsig,dtvar,dtzero,dsig,dvar,
     2               dweight,dxout,nbias,nfre,npoly

c common old scalars
      real*8 tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize
      real*8 tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,ybottom,ytop
      real*8 dlamp,dllamp,dlnu,dlper,dlpower
      integer ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput
      integer mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt
      integer ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok
      integer nright,ntcol,nthis,ntop
      integer numact,numraw,numred,nuplim,nzoom
      common/scalar2/tcur,tlolim,tmark,toff,toffl,tput,tresolv,tsize,
     1               tuplim,tuplimit,tlozoom,tupzoom,xleft,xright,
     2               ybottom,ytop,dlamp,dllamp,dlnu,dlper,dlpower,
     3               ma,mb,magmark,magspan,mflag,mcur,mhigh,mlow,mput,
     4               mazoom,mbzoom,nactual,nbins,nbottom,nbrake,ndigt,
     5               ndim,ndim2,negf,nleft,nlolim,nocol,nxcol,nparseok,
     6               nright,ntcol,nthis,ntop,numact,numraw,numred,
     7               nuplim,nzoom

c local variables
      integer nq,nqq

      nq=0
      nqq=0

      do nq=1,20
       if (dlpower.gt.dgpower(nq)) then
        do nqq=19,nq,-1
         dgpower(nqq+1)=dgpower(nqq)
         dgnu(nqq+1)=dgnu(nqq)
         dgper(nqq+1)=dgper(nqq)
        enddo
        dgpower(nq)=dlpower
        dgnu(nq)=dlnu
        dgper(nq)=dlper
        return
       endif
      enddo
      return
      end



