/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;

public class Fits {
    private ArrayDataInput dataStr;
    private Vector hduList = new Vector();
    private boolean atEOF;

    public static String version() {
        return "0.96a";
    }

    public Fits() {
    }

    public Fits(InputStream str) throws FitsException {
        this(str, false);
    }

    public Fits(InputStream str, boolean compressed) throws FitsException {
        this.streamInit(str, compressed, false);
    }

    protected void streamInit(InputStream str, boolean compressed, boolean seekable) throws FitsException {
        if (str == null) {
            throw new FitsException("Null input stream");
        }
        if (compressed) {
            try {
                str = new GZIPInputStream(str);
            }
            catch (IOException e) {
                throw new FitsException("Cannot inflate input stream" + e);
            }
        }
        this.dataStr = str instanceof ArrayDataInput ? (ArrayDataInput)((Object)str) : new BufferedDataInputStream(str);
    }

    protected void randomInit(String filename) throws FitsException {
        String permissions = "r";
        File f = new File(filename);
        if (!f.exists() || !f.canRead()) {
            throw new FitsException("Non-existent or unreadable file");
        }
        if (f.canWrite()) {
            permissions = permissions + "w";
        }
        try {
            this.dataStr = new BufferedFile(filename, permissions);
            ((BufferedFile)this.dataStr).seek(0L);
        }
        catch (IOException e) {
            throw new FitsException("Unable to open file " + filename);
        }
    }

    public Fits(File myFile) throws FitsException {
        this(myFile, false);
    }

    public Fits(File myFile, boolean compressed) throws FitsException {
        this.fileInit(myFile, compressed);
    }

    protected void fileInit(File myFile, boolean compressed) throws FitsException {
        try {
            FileInputStream str = new FileInputStream(myFile);
            this.streamInit(str, compressed, true);
        }
        catch (IOException e) {
            throw new FitsException("Unable to create Input Stream from File: " + myFile);
        }
    }

    public Fits(String filename) throws FitsException {
        if (filename == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        boolean compressed = FitsUtil.isCompressed(filename);
        int len = filename.length();
        if (len > 4 && filename.substring(0, 5).equalsIgnoreCase("http:")) {
            URL myURL;
            try {
                myURL = new URL(filename);
            }
            catch (IOException e) {
                throw new FitsException("Unable to convert string to URL: " + filename);
            }
            try {
                InputStream is = myURL.openStream();
                this.streamInit(is, compressed, false);
            }
            catch (IOException e) {
                throw new FitsException("Unable to open stream from URL:" + filename + " Exception=" + e);
            }
        }
        if (compressed) {
            this.fileInit(new File(filename), true);
        } else {
            this.randomInit(filename);
        }
    }

    public Fits(URL myURL) throws FitsException {
        this(myURL, FitsUtil.isCompressed(myURL.getFile()));
    }

    public Fits(URL myURL, boolean compressed) throws FitsException {
        try {
            this.streamInit(myURL.openStream(), compressed, false);
        }
        catch (IOException e) {
            throw new FitsException("Unable to open input from URL:" + myURL);
        }
    }

    public BasicHDU[] read() throws FitsException {
        this.readToEnd();
        int size = this.getNumberOfHDUs();
        if (size == 0) {
            return null;
        }
        Object[] hdus = new BasicHDU[size];
        this.hduList.copyInto(hdus);
        return hdus;
    }

    public BasicHDU readHDU() throws FitsException, IOException {
        if (this.dataStr == null || this.atEOF) {
            return null;
        }
        Header hdr = Header.readHeader(this.dataStr);
        if (hdr == null) {
            this.atEOF = true;
            return null;
        }
        Data datum = hdr.makeData();
        datum.read(this.dataStr);
        BasicHDU nextHDU = FitsFactory.HDUFactory(hdr, datum);
        this.hduList.addElement(nextHDU);
        return nextHDU;
    }

    public void skipHDU(int n) throws FitsException, IOException {
        for (int i = 0; i < n; ++i) {
            this.skipHDU();
        }
    }

    public void skipHDU() throws FitsException, IOException {
        if (this.atEOF) {
            return;
        }
        Header hdr = new Header(this.dataStr);
        if (hdr == null) {
            this.atEOF = true;
            return;
        }
        int dataSize = (int)hdr.getDataSize();
        this.dataStr.skip(dataSize);
    }

    public BasicHDU getHDU(int n) throws FitsException, IOException {
        int size;
        for (int i = size = this.getNumberOfHDUs(); i <= n; ++i) {
            BasicHDU hdu = this.readHDU();
            if (hdu != null) continue;
            return null;
        }
        try {
            return (BasicHDU)this.hduList.elementAt(n);
        }
        catch (NoSuchElementException e) {
            throw new FitsException("Internal Error: hduList build failed");
        }
    }

    private void readToEnd() throws FitsException {
        while (this.dataStr != null && !this.atEOF) {
            try {
                if (this.readHDU() != null) continue;
                break;
            }
            catch (IOException e) {
                throw new FitsException("IO error: " + e);
            }
        }
    }

    public int size() throws FitsException {
        this.readToEnd();
        return this.getNumberOfHDUs();
    }

    public void addHDU(BasicHDU myHDU) throws FitsException {
        this.insertHDU(myHDU, this.getNumberOfHDUs());
    }

    public void insertHDU(BasicHDU myHDU, int n) throws FitsException {
        if (myHDU == null) {
            return;
        }
        if (n < 0 || n > this.getNumberOfHDUs()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + n);
        }
        try {
            if (n == 0) {
                if (this.getNumberOfHDUs() > 0) {
                    ((BasicHDU)this.hduList.elementAt(0)).setPrimaryHDU(false);
                }
                if (myHDU.canBePrimary()) {
                    myHDU.setPrimaryHDU(true);
                    this.hduList.insertElementAt(myHDU, 0);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                    myHDU.setPrimaryHDU(false);
                    this.hduList.insertElementAt(myHDU, 1);
                }
            } else {
                myHDU.setPrimaryHDU(false);
                this.hduList.insertElementAt(myHDU, n);
            }
        }
        catch (NoSuchElementException e) {
            throw new FitsException("hduList inconsistency in insertHDU");
        }
    }

    public void deleteHDU(int n) throws FitsException {
        int size = this.getNumberOfHDUs();
        if (n < 0 || n >= size) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        try {
            this.hduList.removeElementAt(n);
            if (n == 0 && size > 1) {
                BasicHDU newFirst = (BasicHDU)this.hduList.elementAt(0);
                if (newFirst.canBePrimary()) {
                    newFirst.setPrimaryHDU(true);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new FitsException("Internal Error: hduList Vector Inconsitency");
        }
    }

    public void write(DataOutput os) throws FitsException {
        ArrayDataOutput obs;
        boolean newOS = false;
        if (os instanceof ArrayDataOutput) {
            obs = (ArrayDataOutput)os;
        } else if (os instanceof DataOutputStream) {
            newOS = true;
            obs = new BufferedDataOutputStream((DataOutputStream)os);
        } else {
            throw new FitsException("Cannot create ArrayDataOutput from class " + os.getClass().getName());
        }
        for (int i = 0; i < this.getNumberOfHDUs(); ++i) {
            try {
                BasicHDU hh = (BasicHDU)this.hduList.elementAt(i);
                hh.write(obs);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                throw new FitsException("Internal Error: Vector Inconsistency" + e);
            }
        }
        if (newOS) {
            try {
                obs.flush();
                obs.close();
            }
            catch (IOException e) {
                System.err.println("Warning: error closing FITS output stream");
            }
        }
    }

    public void read(InputStream is) throws FitsException, IOException {
        boolean newIS = false;
        this.dataStr = is instanceof ArrayDataInput ? (ArrayDataInput)((Object)is) : new BufferedDataInputStream(is);
        this.read();
        if (newIS) {
            this.dataStr.close();
            this.dataStr = null;
        }
    }

    public int currentSize() {
        return this.hduList.size();
    }

    public int getNumberOfHDUs() {
        return this.hduList.size();
    }

    public ArrayDataInput getStream() {
        return this.dataStr;
    }

    public void setStream(ArrayDataInput stream) {
        this.dataStr = stream;
        this.atEOF = false;
    }

    public static BasicHDU makeHDU(Header h) throws FitsException {
        Data d = FitsFactory.dataFactory(h);
        return FitsFactory.HDUFactory(h, d);
    }

    public static BasicHDU makeHDU(Object o) throws FitsException {
        return FitsFactory.HDUFactory(o);
    }

    public static BasicHDU makeHDU(Data datum) throws FitsException {
        Header hdr = new Header();
        datum.fillHeader(hdr);
        return FitsFactory.HDUFactory(hdr, datum);
    }
}

