/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.TableData;

public abstract class TableHDU
extends BasicHDU {
    private TableData table;
    private int currentColumn;

    TableHDU(TableData td) {
        this.table = td;
    }

    public Object[] getRow(int row) throws FitsException {
        return this.table.getRow(row);
    }

    public Object getColumn(String colName) throws FitsException {
        return this.getColumn(this.findColumn(colName));
    }

    public Object getColumn(int col) throws FitsException {
        return this.table.getColumn(col);
    }

    public Object getElement(int row, int col) throws FitsException {
        return this.table.getElement(row, col);
    }

    public void setRow(int row, Object[] newRow) throws FitsException {
        this.table.setRow(row, newRow);
    }

    public void setColumn(String colName, Object newCol) throws FitsException {
        this.setColumn(this.findColumn(colName), newCol);
    }

    public void setColumn(int col, Object newCol) throws FitsException {
        this.table.setColumn(col, newCol);
    }

    public void setElement(int row, int col, Object element) throws FitsException {
        this.table.setElement(row, col, element);
    }

    public int addRow(Object[] newRow) throws FitsException {
        int row = this.table.addRow(newRow);
        this.myHeader.addValue("NAXIS2", row, (String)null);
        return row;
    }

    public int findColumn(String colName) {
        for (int i = 0; i < this.getNCols(); ++i) {
            String val = this.myHeader.getStringValue("TTYPE" + (i + 1));
            if (val == null || !val.trim().equals(colName)) continue;
            return i;
        }
        return -1;
    }

    public abstract int addColumn(Object var1) throws FitsException;

    public int getNCols() {
        return this.table.getNCols();
    }

    public int getNRows() {
        return this.table.getNRows();
    }

    public String getColumnName(int index) {
        String ttype = this.myHeader.getStringValue("TTYPE" + (index + 1));
        if (ttype != null) {
            ttype = ttype.trim();
        }
        return ttype;
    }

    public void setColumnName(int index, String name, String comment) throws FitsException {
        if (this.getNCols() > index && index >= 0) {
            this.myHeader.positionAfterIndex("TFORM", index + 1);
            this.myHeader.addValue("TTYPE" + (index + 1), name, comment);
        }
    }

    public String getColumnFormat(int index) throws FitsException {
        int flds = this.myHeader.getIntValue("TFIELDS", 0);
        if (index < 0 || index >= flds) {
            throw new FitsException("Bad column index " + index + " (only " + flds + " columns)");
        }
        return this.myHeader.getStringValue("TFORM" + (index + 1)).trim();
    }

    public void setCurrentColumn(int col) {
        this.myHeader.positionAfterIndex("TFORM", col + 1);
    }
}

