/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import nom.tam.util.FormatException;

public class ByteParser {
    private byte[] input;
    private int offset;
    private int numberLength;
    private boolean foundSign;
    private boolean fillFields = false;

    public ByteParser(byte[] input) {
        this.input = input;
        this.offset = 0;
    }

    public void setBuffer(byte[] buf) {
        this.input = buf;
        this.offset = 0;
    }

    public byte[] getBuffer() {
        return this.input;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setFillFields(boolean flag) {
        this.fillFields = flag;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getNumberLength() {
        return this.numberLength;
    }

    public double getDouble() throws FormatException {
        return this.getDouble(this.input.length - this.offset);
    }

    public double getDouble(int length) throws FormatException {
        int startOffset = this.offset;
        boolean error = true;
        double number = 0.0;
        boolean i = false;
        if ((length -= this.skipWhite(length)) == 0) {
            return 0.0;
        }
        double mantissaSign = this.checkSign();
        if (this.foundSign) {
            --length;
        }
        number = this.getBareInteger(length);
        length -= this.numberLength;
        if (this.numberLength > 0) {
            error = false;
        }
        if (length > 0 && this.input[this.offset] == 46) {
            double numerator;
            ++this.offset;
            if ((numerator = this.getBareInteger(--length)) > 0.0) {
                number += numerator / Math.pow(10.0, this.numberLength);
            }
            length -= this.numberLength;
            if (this.numberLength > 0) {
                error = false;
            }
        }
        if (error) {
            this.offset = startOffset;
            this.numberLength = 0;
            throw new FormatException("Invalid real field");
        }
        if (length > 0 && (this.input[this.offset] == 101 || this.input[this.offset] == 69 || this.input[this.offset] == 100 || this.input[this.offset] == 68)) {
            ++this.offset;
            if (--length > 0) {
                int sign = this.checkSign();
                if (this.foundSign) {
                    --length;
                }
                int exponent = (int)this.getBareInteger(length);
                number *= Math.pow(10.0, exponent * sign);
                length -= this.numberLength;
            }
        }
        if (this.fillFields && length > 0) {
            if (this.isWhite(length)) {
                this.offset += length;
            } else {
                this.numberLength = 0;
                this.offset = startOffset;
                throw new FormatException("Non-blanks following real.");
            }
        }
        this.numberLength = this.offset - startOffset;
        return mantissaSign * number;
    }

    public float getFloat() throws FormatException {
        return (float)this.getDouble(this.input.length - this.offset);
    }

    public float getFloat(int length) throws FormatException {
        return (float)this.getDouble(length);
    }

    public int getInt(int length) throws FormatException {
        int startOffset = this.offset;
        length -= this.skipWhite(length);
        int number = 0;
        boolean error = true;
        int sign = this.checkSign();
        if (this.foundSign) {
            --length;
        }
        while (length > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            number = number * 10 + this.input[this.offset] - 48;
            ++this.offset;
            --length;
            error = false;
        }
        if (error) {
            this.numberLength = 0;
            this.offset = startOffset;
            throw new FormatException("Invalid Integer");
        }
        if (length > 0 && this.fillFields) {
            if (this.isWhite(length)) {
                this.offset += length;
            } else {
                this.numberLength = 0;
                this.offset = startOffset;
                throw new FormatException("Non-white following integer");
            }
        }
        this.numberLength = this.offset - startOffset;
        return sign * number;
    }

    public int getInt() throws FormatException {
        return this.getInt(this.input.length - this.offset);
    }

    public long getLong(int length) throws FormatException {
        int startOffset = this.offset;
        length -= this.skipWhite(length);
        long number = 0L;
        boolean error = true;
        long sign = this.checkSign();
        if (this.foundSign) {
            --length;
        }
        while (length > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            number = number * 10L + (long)this.input[this.offset] - 48L;
            error = false;
            ++this.offset;
            --length;
        }
        if (error) {
            this.numberLength = 0;
            this.offset = startOffset;
            throw new FormatException("Invalid long number");
        }
        if (length > 0 && this.fillFields) {
            if (this.isWhite(length)) {
                this.offset += length;
            } else {
                this.offset = startOffset;
                this.numberLength = 0;
                throw new FormatException("Non-white following long");
            }
        }
        this.numberLength = this.offset - startOffset;
        return sign * number;
    }

    public String getString(int length) {
        String s = new String(this.input, this.offset, length);
        this.offset += length;
        this.numberLength = length;
        return s;
    }

    public boolean getBoolean() throws FormatException {
        return this.getBoolean(this.input.length - this.offset);
    }

    public boolean getBoolean(int length) throws FormatException {
        int startOffset = this.offset;
        if ((length -= this.skipWhite(length)) == 0) {
            throw new FormatException("Blank boolean field");
        }
        boolean value = false;
        if (this.input[this.offset] == 84 || this.input[this.offset] == 116) {
            value = true;
        } else if (this.input[this.offset] != 70 && this.input[this.offset] != 102) {
            this.numberLength = 0;
            this.offset = startOffset;
            throw new FormatException("Invalid boolean value");
        }
        ++this.offset;
        if (this.fillFields && --length > 0) {
            if (this.isWhite(length)) {
                this.offset += length;
            } else {
                this.numberLength = 0;
                this.offset = startOffset;
                throw new FormatException("Non-white following boolean");
            }
        }
        this.numberLength = this.offset - startOffset;
        return value;
    }

    public void skip(int nBytes) {
        this.offset += nBytes;
    }

    private double getBareInteger(int length) {
        int startOffset = this.offset;
        double number = 0.0;
        while (length > 0 && this.input[this.offset] >= 48 && this.input[this.offset] <= 57) {
            number *= 10.0;
            number += (double)(this.input[this.offset] - 48);
            ++this.offset;
            --length;
        }
        this.numberLength = this.offset - startOffset;
        return number;
    }

    public int skipWhite(int length) {
        int i;
        for (i = 0; i < length && (this.input[this.offset + i] == 32 || this.input[this.offset + i] == 9 || this.input[this.offset + i] == 10 || this.input[this.offset + i] == 13); ++i) {
        }
        this.offset += i;
        return i;
    }

    private int checkSign() {
        this.foundSign = false;
        if (this.input[this.offset] == 43) {
            this.foundSign = true;
            ++this.offset;
            return 1;
        }
        if (this.input[this.offset] == 45) {
            this.foundSign = true;
            ++this.offset;
            return -1;
        }
        return 1;
    }

    public boolean isWhite(int length) {
        int oldOffset = this.offset;
        boolean value = this.skipWhite(length) == length;
        this.offset = oldOffset;
        return value;
    }
}

