/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.GBC;
import AAVSOtools.RemarkOMatic;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RangeWindow
extends JDialog
implements ActionListener {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 150;
    private JButton saveRemarksToRangeButton = new JButton();
    private JTextField saveRangeFromField = new JTextField();
    private JTextField saveRangeToField = new JTextField();
    private DecimalFormat imageNumberFormat = new DecimalFormat("0000");
    private static JFrame frame;
    private RemarkOMatic rom;

    public RangeWindow(Frame frame, RemarkOMatic remarkOMatic, String string) {
        super(frame, "Set Range", true);
        this.rom = remarkOMatic;
        this.setSize(300, 214);
        this.setModal(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() / 3.0), (int)(dimension.getHeight() / 3.0));
        Container container = this.getContentPane();
        container.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("First image number: "), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 0).setAnchor(13));
        jPanel.add((Component)this.setupField(this.saveRangeFromField, 6, "Enter as NNN, NNNN, or aNNNN"), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        this.saveRangeFromField.setText(string);
        jPanel.add((Component)new JLabel("Last image number: "), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 0).setAnchor(13));
        jPanel.add((Component)this.setupField(this.saveRangeToField, 6, "Enter as NNN, NNNN, or aNNNN"), new GBC(1, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        jPanel.add((Component)this.setupButton(this.saveRemarksToRangeButton, "Add remarks to range", null), new GBC(0, 2, 2, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        container.add(jPanel2);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private JButton setupButton(JButton jButton, String string, Icon icon) {
        jButton.addActionListener(this);
        jButton.setMnemonic(10);
        jButton.setText(string);
        jButton.setIcon(icon);
        return jButton;
    }

    private JTextField setupField(JTextField jTextField, int n, String string) {
        jTextField.setColumns(n);
        jTextField.setEditable(true);
        jTextField.setToolTipText(string);
        jTextField.setBackground(Color.WHITE);
        return jTextField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveRemarksToRangeButton) {
            String string = this.rom.getImageNumberString(this.saveRangeFromField);
            String string2 = this.rom.getImageNumberString(this.saveRangeToField);
            if (this.rom.getRemarkAreaText().equals("")) {
                JOptionPane.showMessageDialog(null, "You must enter a remark for these records!", "Warning", 0);
            } else if (this.saveRangeFromField.getText().equals("") || this.saveRangeToField.getText().equals("") || this.rom.getImageNumberInt(this.saveRangeFromField) > this.rom.getImageNumberInt(this.saveRangeToField)) {
                JOptionPane.showMessageDialog(null, "You must enter a valid range!", "Warning", 0);
            } else {
                try {
                    this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
                    String string3 = this.rom.getBaseURL() + "api.upd_img_info";
                    String string4 = "&comments=" + URLEncoder.encode(this.rom.getRemarkAreaText().trim(), "UTF-8") + "&reviewer=" + URLEncoder.encode(this.rom.getReviewerInitials().trim(), "UTF-8") + "&telescope=" + URLEncoder.encode((this.rom.telescopeBox.getSelectedItem() + "").trim(), "UTF-8") + "&date=" + URLEncoder.encode(this.rom.getDate().trim(), "UTF-8") + "&fromfile=" + URLEncoder.encode((string + ".fits").trim(), "UTF-8") + "&tofile=" + URLEncoder.encode((string2 + ".fits").trim(), "UTF-8");
                    int n = this.rom.postCommand(string3, string4);
                    this.rom.clearFields();
                    this.getRootPane().setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.getRootPane().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(null, "Exception: " + unsupportedEncodingException.getMessage(), "Warning", 0);
                }
                this.dispose();
            }
        }
    }
}

