/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.GBC;
import AAVSOtools.RangeWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.util.Calendar;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RemarkOMatic
extends JPanel
implements ActionListener,
FocusListener,
ItemListener,
KeyListener,
WindowListener {
    private static final int WIDTH = 320;
    private static final int HEIGHT = 600;
    private static final String DATABASE = "aavsonet";
    private static final String TABLE = "image_info";
    private static final String VERSION = " - 2.1.1";
    private static final String VERSION_DATE = "09/16/2019";
    private static final String USER_PREFERENCES_FILE = "remarkomatic.ini";
    private static final String DEFAULT_LOGFILE = "remarks.txt";
    private static final String DEFAULT_MAC_FOLDER = "Documents";
    private static final String BASE_URL = "https://www.aavso.org/vsx/index.php?view=";
    private JButton clearButton = new JButton();
    private JButton displayButton = new JButton();
    private JButton exportButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton saveRangeButton = new JButton();
    private JButton quitButton = new JButton();
    private JButton deleteButton = new JButton();
    private JButton findButton = new JButton();
    private JButton saveEditButton = new JButton();
    private JButton markReviewedButton = new JButton();
    private JButton addInitialsButton = new JButton();
    private JButton unreviewedButton = new JButton();
    private JCheckBox blankBox = new JCheckBox();
    private JCheckBox cloudsBox = new JCheckBox();
    private JCheckBox cosmicBox = new JCheckBox();
    private JCheckBox donutBox = new JCheckBox();
    private JCheckBox focusBox = new JCheckBox();
    private JCheckBox ghostBox = new JCheckBox();
    private JCheckBox objectBox = new JCheckBox();
    private JCheckBox otherBox = new JCheckBox();
    private JCheckBox saturatedBox = new JCheckBox();
    private JCheckBox gradationBox = new JCheckBox();
    private JCheckBox trailedBox = new JCheckBox();
    private JCheckBox glintBox = new JCheckBox();
    private JCheckBox reviewedAllBox = new JCheckBox();
    public JComboBox<String> telescopeBox;
    private JComboBox<String> reportTelescopeBox;
    private JComboBox<String> editTelescopeBox;
    private JComboBox<String> reviewerTelescopeBox;
    private JRadioButton vButton = new JRadioButton();
    private JRadioButton hButton = new JRadioButton();
    private JRadioButton dButton = new JRadioButton();
    private JRadioButton fakeButton = new JRadioButton();
    ButtonGroup directionButtons = new ButtonGroup();
    private JTextArea remarkArea = new JTextArea();
    private JTextArea editRemarkArea = new JTextArea();
    private JTextField dateField = new JTextField();
    private JTextField reportDateField = new JTextField();
    private JTextField editDateField = new JTextField();
    private JTextField imageNumberField = new JTextField();
    private JTextField reportImageNumberField = new JTextField();
    private JTextField editImageNumberField = new JTextField();
    private JTextField reviewedFromField = new JTextField();
    private JTextField reviewedToField = new JTextField();
    private JTextField reviewerDateField = new JTextField();
    private JFrame reviewedFrame;
    private static JFrame frame;
    private String blankText = ", blank image";
    private String cloudsText = ", clouds";
    private String cosmicText = ", cosmic particle trail";
    private String donutText = ", donut";
    private String focusText = ", focus problem";
    private String ghostText = ", ghost image";
    private String objectText = ", satellite/airplane/meteor trail";
    private String saturatedText = ", saturated";
    private String glintText = ", glint effects";
    private String gradationText = ", gradation in brightness";
    private String trailedText = ", trailed";
    private String vButtonText = " (V)";
    private String hButtonText = " (H)";
    private String dButtonText = " (D)";
    private String[] reviewerList = new String[]{"EOW", "KQR", "SJB", "SXN", "TMT", "AAH", "MQE"};
    private String[] telescopes = null;
    private String imnum = null;
    private String date = null;
    private String recordDate = null;
    private String telescope = null;
    private String imageNumber = null;
    private String previousTab = null;
    private String logfile = null;
    private String logfileFolder = null;
    private String reviewerInitials = null;
    private String[] telescopeName;
    private String[] dateNumber;
    private String[] filename;
    private String[] object;
    private String[] filter;
    private String[] exptime;
    private String[] comments;
    private String[] reviewer;
    private int recordCount;
    private int commentCount;
    private Boolean directionSelected = false;
    private DecimalFormat dateFormat = new DecimalFormat("00");
    public DecimalFormat imageNumberFormat = new DecimalFormat("0000");
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);

    public RemarkOMatic() {
        System.out.println("RemarkOMatic Initializing\nhttps://www.aavso.org/vsx/index.php?view=");
        this.setSize(320, 600);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() / 3.0), (int)(dimension.getHeight() / 3.0));
        this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("Telescope:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.getTelescopes());
        this.telescopeBox = new JComboBox<String>(defaultComboBoxModel);
        jPanel.add(this.setupComboBox(this.telescopeBox, null), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        jPanel.add((Component)new JLabel("Date (yymmdd):"), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        jPanel.add((Component)this.setupField(this.dateField, 6, null), new GBC(1, 1, 2, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel("Image number:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 0, 5).setAnchor(13));
        jPanel2.add((Component)this.setupField2(this.imageNumberField, 6, "Enter as NNN, NNNN, or aNNNN"), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 0, 0));
        URL uRL = this.getClass().getResource("images/nextButton.jpg");
        Icon icon = uRL != null ? new ImageIcon(uRL) : UIManager.getIcon("OptionPane.warningIcon");
        jPanel2.add((Component)this.setupButton(this.nextButton, null, icon), new GBC(2, 0, 0, 0).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.setupBox(this.blankBox, "blank image"), new GBC(0, 0, 1, 1).setInsets(5, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.cloudsBox, "clouds"), new GBC(0, 1, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.cosmicBox, "cosmic particle"), new GBC(0, 2, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.donutBox, "donut"), new GBC(0, 3, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.focusBox, "focus"), new GBC(0, 4, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.ghostBox, "ghost"), new GBC(0, 5, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.glintBox, "glint"), new GBC(0, 6, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.gradationBox, "gradation"), new GBC(1, 0, 1, 1).setInsets(2, 0, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.objectBox, "plane/satellite"), new GBC(1, 1, 1, 1).setInsets(2, 0, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.saturatedBox, "saturated"), new GBC(1, 2, 1, 1).setInsets(2, 0, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupBox(this.trailedBox, "trailed"), new GBC(1, 3, 1, 1).setInsets(2, 0, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupRadioButton(this.vButton, "vertically", this.directionButtons), new GBC(1, 4, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupRadioButton(this.hButton, "horizontally", this.directionButtons), new GBC(1, 5, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        jPanel3.add((Component)this.setupRadioButton(this.dButton, "diagonally", this.directionButtons), new GBC(1, 6, 1, 1).setInsets(2, 5, 0, 5).setAnchor(17));
        this.setupRadioButton(this.fakeButton, null, this.directionButtons);
        jPanel3.add((Component)new JLabel("Remarks:"), new GBC(0, 7, 1, 1).setWeight(100.0, 0.0).setInsets(10, 5, 0, 5).setAnchor(17));
        JScrollPane jScrollPane = new JScrollPane(this.setupArea(this.remarkArea, 4, 20));
        jPanel3.add((Component)jScrollPane, new GBC(0, 8, 2, 3).setWeight(100.0, 0.0).setFill(1).setInsets(5, 5, 10, 5).setAnchor(17));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.setupButton(this.clearButton, "Clear", null), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setAnchor(13));
        jPanel4.add((Component)this.setupButton(this.saveButton, "Save", null), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setAnchor(17));
        jPanel4.add((Component)this.setupButton(this.saveRangeButton, "Save to Range...", null), new GBC(0, 1, 2, 1).setWeight(100.0, 0.0));
        jPanel4.add((Component)this.setupButton(this.markReviewedButton, "Mark Images Reviewed...", null), new GBC(0, 2, 2, 1).setWeight(100.0, 0.0));
        this.saveButton.setEnabled(false);
        this.saveRangeButton.setEnabled(false);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel5.add((Component)jPanel, new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel5.add((Component)jPanel2, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel5.add((Component)jPanel3, new GBC(0, 2, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel5.add((Component)jPanel4, new GBC(0, 3, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)new JLabel("Telescope:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        this.reportTelescopeBox = new JComboBox<String>(this.telescopes);
        jPanel6.add(this.setupComboBox(this.reportTelescopeBox, null), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        jPanel6.add((Component)new JLabel("Date (yymmdd):"), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        jPanel6.add((Component)this.setupField(this.reportDateField, 6, null), new GBC(1, 1, 2, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        jPanel7.add((Component)new JLabel("Image number:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 0, 5).setAnchor(13));
        jPanel7.add((Component)this.setupField(this.reportImageNumberField, 6, "Enter as NNN, NNNN, or aNNNN"), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 0, 0));
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        JTextArea jTextArea = new JTextArea("\n To get a report: \n   1. select telescope  \n   2. choose date  \n   3. select image number  \n (leave the date or image \n number blank to get ALL) \n");
        jTextArea.setBackground(Color.LIGHT_GRAY);
        jPanel8.add((Component)jTextArea, new GBC(0, 0, 0, 0).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5));
        JPanel jPanel9 = new JPanel(new GridBagLayout());
        jPanel9.add((Component)this.setupButton(this.displayButton, "Display Report", null), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0));
        jPanel9.add((Component)this.setupButton(this.exportButton, "Create Text File", null), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0));
        jPanel9.add((Component)this.setupButton(this.unreviewedButton, "Show Un-Reviewed Dates", null), new GBC(0, 2, 1, 1).setWeight(100.0, 0.0));
        JPanel jPanel10 = new JPanel(new GridBagLayout());
        jPanel6.setBorder(BorderFactory.createEtchedBorder());
        jPanel10.add((Component)jPanel6, new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel10.add((Component)jPanel7, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel10.add((Component)jPanel8, new GBC(0, 2, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel10.add((Component)jPanel9, new GBC(0, 3, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        JPanel jPanel11 = new JPanel(new GridBagLayout());
        jPanel11.add((Component)new JLabel("Telescope:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        this.editTelescopeBox = new JComboBox<String>(this.telescopes);
        jPanel11.add(this.setupComboBox(this.editTelescopeBox, null), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        jPanel11.add((Component)new JLabel("Date (yymmdd):"), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        jPanel11.add((Component)this.setupField(this.editDateField, 6, null), new GBC(1, 1, 2, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        JPanel jPanel12 = new JPanel(new GridBagLayout());
        jPanel12.add((Component)new JLabel("Image number:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 0, 5).setAnchor(13));
        jPanel12.add((Component)this.setupField(this.editImageNumberField, 6, "Enter as NNN, NNNN, or aNNNN"), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 0, 0));
        JPanel jPanel13 = new JPanel(new GridBagLayout());
        jPanel13.add((Component)this.setupButton(this.findButton, "Find Record", null), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0));
        jPanel13.add((Component)new JLabel("Remarks:"), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(10, 5, 0, 5).setAnchor(17));
        JScrollPane jScrollPane2 = new JScrollPane(this.setupArea(this.editRemarkArea, 4, 20));
        jPanel13.add((Component)jScrollPane2, new GBC(0, 2, 2, 3).setWeight(100.0, 0.0).setFill(1).setInsets(5, 5, 10, 5).setAnchor(17));
        JPanel jPanel14 = new JPanel(new GridBagLayout());
        jPanel14.add((Component)this.setupButton(this.deleteButton, "Delete Comment", null), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0));
        jPanel14.add((Component)this.setupButton(this.saveEditButton, "Save Edits", null), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0));
        this.deleteButton.setEnabled(false);
        this.saveEditButton.setEnabled(false);
        JPanel jPanel15 = new JPanel(new GridBagLayout());
        jPanel11.setBorder(BorderFactory.createEtchedBorder());
        jPanel15.add((Component)jPanel11, new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel15.add((Component)jPanel12, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel15.add((Component)jPanel13, new GBC(0, 2, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel15.add((Component)jPanel14, new GBC(0, 3, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                RemarkOMatic.this.tabChanged(jTabbedPane.getTitleAt(n));
            }
        };
        jTabbedPane.addChangeListener(changeListener);
        jTabbedPane.addTab("Enter", jPanel5);
        jTabbedPane.addTab("Report", jPanel10);
        jTabbedPane.addTab("Edit", jPanel15);
        this.add(jTabbedPane);
        this.getUserDefaults(USER_PREFERENCES_FILE);
        this.getReviewerInfo();
    }

    public void disableCertProcessing() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        }
        catch (Exception exception) {
            System.out.println("CertFix Exception: " + exception.getMessage());
        }
    }

    public void createRecordImageNumberGUI() {
        int n = this.getCount(this.getTelescope(), this.getRecordDate(), "filename", false);
        int n2 = n + 100;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("Telescope:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        this.reviewerTelescopeBox = new JComboBox<String>(this.getTelescopes());
        jPanel.add(this.setupComboBox(this.reviewerTelescopeBox, this.getTelescope()), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        jPanel.add((Component)new JLabel("Date (yymmdd):"), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        jPanel.add((Component)this.setupField(this.reviewerDateField, 6, null), new GBC(1, 1, 2, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5).setAnchor(17));
        this.reviewerDateField.setText(this.getRecordDate());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel("First image viewed:"), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        jPanel2.add((Component)this.setupField(this.reviewedFromField, 6, "Enter as NNN, NNNN, or aNNNN"), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        this.reviewedFromField.setText("101");
        jPanel2.add((Component)new JLabel("Last image viewed:"), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        jPanel2.add((Component)this.setupField(this.reviewedToField, 6, "Enter as NNN, NNNN, or aNNNN"), new GBC(1, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        this.reviewedToField.setText(n2 + "");
        jPanel2.add((Component)this.setupButton(this.addInitialsButton, "Add initials to records", null), new GBC(1, 2, 1, 1).setWeight(100.0, 0.0).setInsets(5, 0, 0, 5).setAnchor(13));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel3.add((Component)jPanel, new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel3.add((Component)jPanel2, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        this.reviewedFrame = new JFrame("Images Viewed");
        RemarkOMatic.createAndShowGUI(this.reviewedFrame, jPanel3, 2);
    }

    public JTextArea setupArea(JTextArea jTextArea, int n, int n2) {
        jTextArea.setRows(n);
        jTextArea.setColumns(n2);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(true);
        jTextArea.setBackground(Color.WHITE);
        jTextArea.addFocusListener(this);
        jTextArea.addKeyListener(this);
        return jTextArea;
    }

    public JCheckBox setupBox(JCheckBox jCheckBox, String string) {
        jCheckBox.addItemListener(this);
        jCheckBox.setText(string);
        return jCheckBox;
    }

    public JButton setupButton(JButton jButton, String string, Icon icon) {
        jButton.addActionListener(this);
        jButton.setMnemonic(10);
        jButton.setText(string);
        jButton.setIcon(icon);
        return jButton;
    }

    public JComboBox<String> setupComboBox(JComboBox<String> jComboBox, Object object) {
        jComboBox.addActionListener(this);
        jComboBox.addItemListener(this);
        jComboBox.setSelectedItem(object);
        return jComboBox;
    }

    public JTextField setupField(JTextField jTextField, int n, String string) {
        jTextField.setColumns(n);
        jTextField.setEditable(true);
        jTextField.setToolTipText(string);
        jTextField.setBackground(Color.WHITE);
        jTextField.addFocusListener(this);
        jTextField.addKeyListener(this);
        return jTextField;
    }

    public JTextField setupField2(JTextField jTextField, int n, String string) {
        jTextField.setColumns(n);
        jTextField.setEditable(true);
        jTextField.setToolTipText(string);
        jTextField.setBackground(Color.WHITE);
        jTextField.addFocusListener(this);
        jTextField.addKeyListener(this);
        return jTextField;
    }

    public JRadioButton setupRadioButton(JRadioButton jRadioButton, String string, ButtonGroup buttonGroup) {
        jRadioButton.setText(string);
        jRadioButton.addItemListener(this);
        jRadioButton.setEnabled(false);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    public void initializeArrays(int n) {
        this.telescopeName = new String[n];
        this.dateNumber = new String[n];
        this.filename = new String[n];
        this.object = new String[n];
        this.filter = new String[n];
        this.exptime = new String[n];
        this.comments = new String[n];
        this.reviewer = new String[n];
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.nextButton) {
            object = this.imageNumberField.getText();
            if (((String)object).equals("")) {
                this.imageNumberField.setText("a" + this.imageNumberFormat.format(Integer.parseInt(this.imnum.substring(1)) + 1));
            } else {
                this.imageNumberField.setText("a" + this.imageNumberFormat.format(this.getImageNumberInt(this.imageNumberField) + 1));
            }
        }
        if (actionEvent.getSource() == this.saveButton && this.validateEntry().booleanValue() && this.addRemarks(this.getDate().trim(), this.getImageNumberString(this.imageNumberField).trim(), this.remarkArea.getText().trim()).booleanValue()) {
            this.clearFields();
        }
        if (actionEvent.getSource() == this.clearButton) {
            this.clearFields();
        }
        if (actionEvent.getSource() == this.displayButton) {
            this.getResults();
        }
        if (actionEvent.getSource() == this.exportButton) {
            this.exportResults();
        }
        if (actionEvent.getSource() == this.deleteButton) {
            this.deleteComment();
            this.clearFields();
        }
        if (actionEvent.getSource() == this.findButton) {
            this.findRecord();
            this.findButton.setSelected(false);
            this.editRemarkArea.requestFocusInWindow();
            this.activateButton(this.saveEditButton);
            this.deleteButton.setEnabled(true);
        }
        if (actionEvent.getSource() == this.saveEditButton) {
            this.editRecord();
            this.clearFields();
        }
        if (actionEvent.getSource() == this.markReviewedButton) {
            this.setTelescope(this.telescopeBox.getSelectedItem() + "");
            if (this.getTelescope() == null || this.getTelescope().equals("")) {
                JOptionPane.showMessageDialog(null, "You must specify a Telescope", "Warning!", 2);
            } else if (this.dateField.getText() == null || this.dateField.getText().equals("")) {
                JOptionPane.showMessageDialog(null, "You must specify a Date", "Warning!", 2);
            } else {
                this.setRecordDate(this.dateField.getText());
                int n = this.getCount(this.getTelescope(), this.getRecordDate(), "filename", true);
                if (n > 0) {
                    this.createRecordImageNumberGUI();
                } else {
                    JOptionPane.showMessageDialog(null, "All records for " + this.getTelescope() + " on " + this.getRecordDate() + "\nhave already been marked as \n\"reviewed\" by " + this.getReviewerInitials(), "Records Already Marked!", 1);
                }
            }
        }
        if (actionEvent.getSource() == this.saveRangeButton) {
            object = new RangeWindow((Frame)frame, this, this.imageNumberField.getText());
        }
        if (actionEvent.getSource() == this.addInitialsButton) {
            this.recordImageRange();
            this.reviewedFrame.dispose();
        }
        if (actionEvent.getSource() == this.unreviewedButton) {
            this.showUnreviewedReport();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.remarkArea) {
            this.activateButton(this.saveButton);
        } else if (focusEvent.getSource() == this.editImageNumberField) {
            this.editRemarkArea.setText("");
            this.saveEditButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.activateButton(this.findButton);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.dateField) {
            this.dateChanged(this.getRecordDate(), this.dateField.getText());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = false;
        char c = '-';
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        c = itemEvent.getStateChange() == 2 ? (char)'-' : '+';
        if (itemSelectable == this.blankBox) {
            this.buildRemarks(this.blankText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.cloudsBox) {
            this.buildRemarks(this.cloudsText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.cosmicBox) {
            this.buildRemarks(this.cosmicText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.donutBox) {
            this.buildRemarks(this.donutText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.focusBox) {
            this.buildRemarks(this.focusText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.ghostBox) {
            this.buildRemarks(this.ghostText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.objectBox) {
            this.buildRemarks(this.objectText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.saturatedBox) {
            this.buildRemarks(this.saturatedText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.glintBox) {
            this.buildRemarks(this.glintText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.gradationBox) {
            this.buildRemarks(this.gradationText, c);
            this.activateButton(this.saveButton);
        } else if (itemSelectable == this.trailedBox) {
            this.buildRemarks(this.trailedText, c);
            this.enableButtons(true);
        } else if (itemSelectable == this.vButton) {
            this.buildRemarks(this.vButtonText, c);
            this.activateButton(this.saveButton);
            this.directionSelected = true;
        } else if (itemSelectable == this.hButton) {
            this.buildRemarks(this.hButtonText, c);
            this.activateButton(this.saveButton);
            this.directionSelected = true;
        } else if (itemSelectable == this.dButton) {
            this.buildRemarks(this.dButtonText, c);
            this.activateButton(this.saveButton);
            this.directionSelected = true;
        } else if (itemSelectable == this.telescopeBox) {
            this.setTelescope(this.telescopeBox.getSelectedItem() + "");
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.editRemarkArea && keyEvent.getKeyCode() == 10) {
            this.activateButton(this.saveEditButton);
        }
        if (keyEvent.getSource() == this.remarkArea && keyEvent.getKeyCode() == 10) {
            this.activateButton(this.saveEditButton);
        }
        if (keyEvent.getSource() == this.dateField && keyEvent.getKeyCode() == 10) {
            this.imageNumberField.requestFocusInWindow();
        }
        if (keyEvent.getSource() == this.imageNumberField && keyEvent.getKeyCode() == 10) {
            this.remarkArea.requestFocusInWindow();
        }
        if (keyEvent.getSource() == this.editDateField && keyEvent.getKeyCode() == 10) {
            this.editImageNumberField.requestFocusInWindow();
        }
        if (keyEvent.getSource() == this.editImageNumberField && keyEvent.getKeyCode() == 10) {
            this.activateButton(this.findButton);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.editRemarkArea) {
            this.saveEditButton.setEnabled(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void tabChanged(String string) {
        if (string.equals("Enter") && this.previousTab == null) {
            this.previousTab = "Enter";
        }
        if (string.equals("Enter") && this.previousTab.equals("Report")) {
            this.dateChanged(this.getRecordDate(), this.reportDateField.getText());
            this.setTelescope(this.reportTelescopeBox.getSelectedItem() + "");
            this.setRecordDate(this.reportDateField.getText());
            this.setImageNumber(this.reportImageNumberField.getText());
            this.telescopeBox.setSelectedItem(this.getTelescope());
            this.dateField.setText(this.getRecordDate());
            this.previousTab = "Enter";
        }
        if (string.equals("Enter") && this.previousTab.equals("Edit")) {
            this.dateChanged(this.getRecordDate(), this.editDateField.getText());
            this.setTelescope(this.editTelescopeBox.getSelectedItem() + "");
            this.setRecordDate(this.editDateField.getText());
            this.setImageNumber(this.editImageNumberField.getText());
            this.telescopeBox.setSelectedItem(this.getTelescope());
            this.dateField.setText(this.getRecordDate());
            this.imageNumberField.setText(this.getImageNumber());
            this.previousTab = "Enter";
        }
        if (string.equals("Report") && this.previousTab.equals("Enter")) {
            this.setTelescope(this.telescopeBox.getSelectedItem() + "");
            this.setRecordDate(this.dateField.getText());
            this.setImageNumber(this.imageNumberField.getText());
            this.reportTelescopeBox.setSelectedItem(this.getTelescope());
            this.reportDateField.setText(this.getRecordDate());
            this.reportImageNumberField.setText(this.getImageNumber());
            if (!this.reportDateField.getText().equals("")) {
                this.activateButton(this.displayButton);
            }
            this.previousTab = "Report";
        }
        if (string.equals("Report") && this.previousTab.equals("Edit")) {
            this.setTelescope(this.editTelescopeBox.getSelectedItem() + "");
            this.setRecordDate(this.editDateField.getText());
            this.setImageNumber(this.editImageNumberField.getText());
            this.reportTelescopeBox.setSelectedItem(this.getTelescope());
            this.reportDateField.setText(this.getRecordDate());
            this.reportImageNumberField.setText("");
            if (!this.reportDateField.getText().equals("")) {
                this.activateButton(this.displayButton);
            }
            this.previousTab = "Report";
        }
        if (string.equals("Edit") && this.previousTab.equals("Enter")) {
            this.setTelescope(this.telescopeBox.getSelectedItem() + "");
            this.setRecordDate(this.dateField.getText());
            this.setImageNumber(this.imageNumberField.getText());
            this.editTelescopeBox.setSelectedItem(this.getTelescope());
            this.editDateField.setText(this.getRecordDate());
            this.editImageNumberField.setText(this.getImageNumber());
            if (!this.editDateField.getText().equals("") && !this.editImageNumberField.getText().equals("")) {
                this.activateButton(this.findButton);
            }
            this.previousTab = "Edit";
            this.editRemarkArea.setText("");
            this.saveEditButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
        if (string.equals("Edit") && this.previousTab.equals("Report")) {
            this.setTelescope(this.reportTelescopeBox.getSelectedItem() + "");
            this.setRecordDate(this.reportDateField.getText());
            this.setImageNumber(this.reportImageNumberField.getText());
            this.editTelescopeBox.setSelectedItem(this.getTelescope());
            this.editDateField.setText(this.getRecordDate());
            this.editImageNumberField.setText(this.getImageNumber());
            if (!this.editDateField.getText().equals("") && !this.editImageNumberField.getText().equals("")) {
                this.activateButton(this.findButton);
            }
            this.previousTab = "Edit";
            this.editRemarkArea.setText("");
            this.saveEditButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void dateChanged(String string, String string2) {
        int n;
        if (string != null && !string.equals("") && !string.equals(string2) && (n = this.getCount(this.getTelescope(), this.getRecordDate(), "filename", true)) > 0) {
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n2 = JOptionPane.showOptionDialog(null, "You have not marked ALL of the images as 'reviewed' the night of " + string + ".\nWould you like to do that now?", "Warning", -1, 2, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                this.createRecordImageNumberGUI();
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setUserDefaults();
        int n = this.getCount(this.getTelescope(), this.getRecordDate(), "filename", true);
        if (n > 0) {
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n2 = JOptionPane.showOptionDialog(null, "You have not marked ALL of the images as 'reviewed' for this night.\nWould you like to do that now?", "Warning", -1, 2, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                this.createRecordImageNumberGUI();
            } else {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public Document getDocument(URL uRL) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(uRL.openStream());
            document.getDocumentElement().normalize();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
        return document;
    }

    public int postCommand(String string, String string2) {
        int n = 0;
        try {
            URL uRL = new URL(string);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Accept", "application/xml");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            n = httpsURLConnection.getResponseCode();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
        }
        return n;
    }

    private String[] getTelescopes() {
        try {
            URL uRL = new URL("https://www.aavso.org/vsx/index.php?view=api.telescopes");
            NodeList nodeList = this.getDocument(uRL).getElementsByTagName("Telescopes").item(0).getChildNodes();
            Element element = (Element)nodeList.item(0);
            String string = element.getTextContent() + "";
            string = string.substring(6, string.length() - 2);
            this.telescopes = new String[string.replaceAll("[^,]", "").length() + 1];
            this.telescopes = string.split("','");
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "Exception: " + malformedURLException.getMessage(), "Warning", 0);
        }
        return this.telescopes;
    }

    public Boolean addRemarks(String string, String string2, String string3) {
        String string4 = "" + this.telescopeBox.getSelectedItem();
        try {
            int n = this.getCount(string4, string, string2 + ".fits", false);
            if (n > 1) {
                JOptionPane.showMessageDialog(null, "Duplicate records exist!", "Warning", 2);
                return false;
            }
            if (n < 1) {
                JOptionPane.showMessageDialog(null, "This image number does not exist!", "Warning", 2);
                return false;
            }
            frame.setCursor(this.waitCursor);
            String string5 = "https://www.aavso.org/vsx/index.php?view=api.upd_img_info";
            String string6 = "&comments=" + URLEncoder.encode(string3.trim(), "UTF-8") + "&reviewer=" + URLEncoder.encode(this.getReviewerInitials().trim(), "UTF-8") + "&telescope=" + URLEncoder.encode(string4.trim(), "UTF-8") + "&date=" + URLEncoder.encode(string.trim(), "UTF-8") + "&fromfile=" + URLEncoder.encode((string2 + ".fits").trim(), "UTF-8");
            int n2 = this.postCommand(string5, string6);
            frame.setCursor(this.defaultCursor);
            if (n2 == 200) {
                return true;
            }
            JOptionPane.showMessageDialog(null, "Something went wrong with when you tried to save.\nPlease check to see if your remarks were uploaded.", "Warning", 0);
            return false;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReportQuery(String string, String string2, String string3) {
        String string4 = null;
        this.recordCount = 0;
        this.commentCount = 0;
        try {
            URL uRL;
            NodeList nodeList;
            frame.setCursor(this.waitCursor);
            String string5 = "https://www.aavso.org/vsx/index.php?view=api.img_info&telescope=" + this.telescope + "&list";
            if (!string2.equals("date")) {
                string5 = string5 + "&date=" + string2;
                string4 = " on " + string2 + ".";
            } else {
                string4 = ".";
            }
            if (!string3.equals("filename")) {
                string5 = string5 + "&filename=" + string3 + ".fits";
            }
            if ((nodeList = this.getDocument(uRL = new URL(string5)).getElementsByTagName("Entry")) != null && nodeList.getLength() > 0) {
                this.recordCount = nodeList.getLength();
                this.initializeArrays(this.recordCount);
                for (int i = 0; i < this.recordCount; ++i) {
                    NodeList nodeList2 = nodeList.item(i).getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Element element = (Element)nodeList2.item(j);
                        String string6 = element.getNodeName();
                        String string7 = element.getTextContent();
                        if ("Telescope".equals(string6)) {
                            this.setTelescopeName(i, string7 + "");
                            continue;
                        }
                        if ("Date".equals(string6)) {
                            this.setDateNumber(i, string7 + "");
                            continue;
                        }
                        if ("Filename".equals(string6)) {
                            this.setFilename(i, string7 + "");
                            continue;
                        }
                        if ("Object".equals(string6)) {
                            this.setObject(i, string7 + "");
                            continue;
                        }
                        if ("Filter".equals(string6)) {
                            this.setFilter(i, string7 + "");
                            continue;
                        }
                        if ("Exptime".equals(string6)) {
                            this.setExptime(i, string7 + "");
                            continue;
                        }
                        if ("Comments".equals(string6)) {
                            this.setComments(i, string7 + "");
                            if (this.getComments(i).equals("")) continue;
                            ++this.commentCount;
                            continue;
                        }
                        if (!"Reviewer".equals(string6)) continue;
                        this.setReviewer(i, string7 + "");
                    }
                }
            } else {
                frame.setCursor(this.defaultCursor);
                JOptionPane.showMessageDialog(null, "There are no records for " + string + string4, "No records found", 1);
            }
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "Exception: " + malformedURLException.getMessage(), "Warning", 0);
        }
        finally {
            frame.setCursor(this.defaultCursor);
        }
    }

    public Boolean recordImageRange() {
        try {
            frame.setCursor(this.waitCursor);
            String string = "https://www.aavso.org/vsx/index.php?view=api.upd_img_info";
            String string2 = "&reviewer=" + URLEncoder.encode(this.getReviewerInitials().trim(), "UTF-8") + "&telescope=" + URLEncoder.encode((this.reviewerTelescopeBox.getSelectedItem() + "").trim(), "UTF-8") + "&date=" + URLEncoder.encode(this.reviewerDateField.getText().trim(), "UTF-8") + "&fromfile=" + URLEncoder.encode((this.getImageNumberString(this.reviewedFromField) + ".fits").trim(), "UTF-8") + "&tofile=" + URLEncoder.encode((this.getImageNumberString(this.reviewedToField) + ".fits").trim(), "UTF-8");
            int n = this.postCommand(string, string2);
            frame.setCursor(this.defaultCursor);
            if (n == 200) {
                return true;
            }
            JOptionPane.showMessageDialog(null, "Something went wrong with when you tried to save.\nPlease check to see if your remarks were uploaded.", "Warning", 0);
            return false;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
            return false;
        }
    }

    public void findRecord() {
        String string = this.editTelescopeBox.getSelectedItem() + "";
        String string2 = this.editDateField.getText();
        String string3 = this.editImageNumberField.getText();
        while (string3.equals("") || string3 == null) {
            string3 = JOptionPane.showInputDialog(null, "You must enter a number for this image:", "Warning", 2);
            this.editImageNumberField.setText(string3);
        }
        string3 = this.getImageNumberString(this.editImageNumberField);
        while (string2.equals("")) {
            string2 = JOptionPane.showInputDialog(null, "You must enter a date for the search:", "Warning", 2);
            this.editDateField.setText(string2);
        }
        this.runReportQuery(string, string2, string3);
        this.editRemarkArea.setText(this.getComments(0));
    }

    public void deleteComment() {
        String string = "" + this.editTelescopeBox.getSelectedItem();
        String string2 = this.editDateField.getText();
        String string3 = this.editImageNumberField.getText();
        while (string3.equals("") || string3 == null) {
            string3 = JOptionPane.showInputDialog(null, "You must enter a number for this image:", "Warning", 2);
            this.editImageNumberField.setText(string3);
        }
        string3 = this.getImageNumberString(this.editImageNumberField);
        try {
            int n = this.getCount(string, string2, string3 + ".fits", false);
            if (n == 0) {
                JOptionPane.showMessageDialog(null, "Record NOT found for:\nTelescope = " + string + "\nDate = " + string2 + "\nImage number = " + string3, "Warning", 2);
            } else {
                frame.setCursor(this.waitCursor);
                String string4 = "https://www.aavso.org/vsx/index.php?view=api.upd_img_info";
                String string5 = "&comments=&reviewer=" + URLEncoder.encode(this.getReviewerInitials().trim(), "UTF-8") + "&telescope=" + URLEncoder.encode(string.trim(), "UTF-8") + "&date=" + URLEncoder.encode(string2.trim(), "UTF-8") + "&fromfile=" + URLEncoder.encode((string3 + ".fits").trim(), "UTF-8");
                int n2 = this.postCommand(string4, string5);
                frame.setCursor(this.defaultCursor);
                if (n2 == 200) {
                    this.editImageNumberField.setText("");
                    JOptionPane.showMessageDialog(null, "Comment deleted", "Warning", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "Something went wrong with when you tried to delete the comment.\nPlease check to see if your remark was deleted.", "Warning", 0);
                }
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
        }
    }

    public int getCount(String string, String string2, String string3, Boolean bl) {
        int n = 0;
        String string4 = "https://www.aavso.org/vsx/index.php?view=api.img_info&telescope=" + string + "&date=" + string2;
        if (!string3.equals("filename")) {
            string4 = string4 + "&filename=" + string3;
        }
        try {
            Element element;
            frame.setCursor(this.waitCursor);
            if (bl.booleanValue()) {
                URL uRL = new URL(string4);
                NodeList nodeList = this.getDocument(uRL).getElementsByTagName("ImageInfo").item(0).getChildNodes();
                element = (Element)nodeList.item(1);
            } else {
                URL uRL = new URL(string4);
                NodeList nodeList = this.getDocument(uRL).getElementsByTagName("ImageInfo").item(0).getChildNodes();
                element = (Element)nodeList.item(0);
            }
            n = Integer.parseInt(element.getTextContent() + "");
            frame.setCursor(this.defaultCursor);
        }
        catch (MalformedURLException malformedURLException) {
            frame.setCursor(this.defaultCursor);
            JOptionPane.showMessageDialog(null, "Exception: " + malformedURLException.getMessage(), "Warning", 0);
        }
        return n;
    }

    public void editRecord() {
        String string = this.editImageNumberField.getText();
        while (string.equals("") || string == null) {
            string = JOptionPane.showInputDialog(null, "You must enter a number for this image:", "Warning", 2);
            this.editImageNumberField.setText(string);
        }
        string = this.getImageNumberString(this.editImageNumberField);
        this.addRemarks(this.editDateField.getText().trim(), string.trim(), this.editRemarkArea.getText().trim());
        JOptionPane.showMessageDialog(null, "Edits Saved", "Saved", 1);
    }

    public Boolean validateEntry() {
        if (this.getDate().equals("") || this.remarkArea.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Record not entered!", "Warning", 0);
            return false;
        }
        if (this.trailedBox.isSelected() && !this.directionSelected.booleanValue()) {
            JOptionPane.showMessageDialog(null, "You must select a direction for the trailing problem\nvertically (V), horizontally (H) or diagonally (D)", "Warning", 0);
            return false;
        }
        return true;
    }

    public void getResults() {
        String string = this.reportTelescopeBox.getSelectedItem() + "";
        String string2 = this.reportDateField.getText();
        String string3 = this.getImageNumberString(this.reportImageNumberField);
        if (string2.equals("")) {
            string2 = "date";
        }
        if (string3.equals("")) {
            string3 = "filename";
        }
        this.runReportQuery(string, string2, string3);
        if (this.recordCount != 0 && this.commentCount != 0) {
            this.printResults(string2);
        } else {
            JOptionPane.showMessageDialog(null, "No comments found!", "Warning", 2);
        }
    }

    public String formatResults(boolean bl) {
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        int n = 0;
        for (int i = 0; i < this.recordCount; ++i) {
            if (!this.getTelescopeName(i).equals(string2) || !this.getDateNumber(i).equals(string3)) {
                if (n > 0) {
                    if (!bl3) {
                        string = string + "\n" + string2 + " - " + string3 + " - " + string4 + "\n\n";
                    }
                    string = string + "Not reviewed        " + n + "\n";
                }
                string2 = this.getTelescopeName(i);
                string3 = this.getDateNumber(i);
                string4 = this.getReviewer(i);
                n = 0;
                bl3 = false;
            }
            if (this.getReviewer(i).equals("")) {
                ++n;
            }
            if (this.getComments(i).equals("")) continue;
            if (!bl3) {
                string = string + "\n" + string2 + " - " + string3 + " - " + string4 + "\n\n";
                bl3 = true;
            }
            string = string + this.getFilename(i) + " - " + this.getObject(i) + " (" + this.getFilter(i) + ", " + this.getExptime(i) + " sec)  " + this.getComments(i) + " -- " + this.getReviewer(i) + "\n";
        }
        if (n > 0) {
            if (!bl3) {
                string = string + "\n" + string2 + " - " + string3 + " - " + string4 + "\n\n";
            }
            string = string + "Not reviewed        " + n + "\n";
        }
        return string.substring(1);
    }

    public String getDate() {
        String string = this.dateField.getText();
        Calendar calendar = Calendar.getInstance();
        String string2 = ("" + calendar.get(1)).substring(2, 4) + this.dateFormat.format(calendar.get(2) + 1) + this.dateFormat.format(calendar.get(5));
        while (string.equals("") || string == null) {
            string = JOptionPane.showInputDialog(null, "You must enter a date for these images\nin the form of YYMMDD:", "Warning", 2);
        }
        this.dateField.setText(string);
        while (Integer.parseInt(string) > Integer.parseInt(string2)) {
            string = JOptionPane.showInputDialog(null, "The date you entered is in the future!\nPlease enter the correct date in the form of YYMMDD:", "Warning", 2);
        }
        this.dateField.setText(string);
        return string;
    }

    public int getImageNumberInt(JTextField jTextField) {
        if (jTextField.getText().startsWith("a") || jTextField.getText().startsWith("A")) {
            return Integer.parseInt(jTextField.getText().substring(1));
        }
        return Integer.parseInt(jTextField.getText());
    }

    public String getImageNumberString(JTextField jTextField) {
        this.imnum = jTextField.getText();
        if (this.imnum.equals("")) {
            return this.imnum;
        }
        if (this.imnum.charAt(0) != 'a' && this.imnum.charAt(0) != 'A') {
            this.imnum = "a" + this.imageNumberFormat.format(Integer.parseInt(this.imnum));
        }
        jTextField.setText(this.imnum);
        return this.imnum;
    }

    public void buildRemarks(String string, char c) {
        String string2 = this.remarkArea.getText();
        if (c == '+') {
            string2 = string2.concat(string);
        } else {
            int n = string2.length();
            if ((string2 = string2.replace(string, "")).length() == n) {
                string2 = string2.replace(string.substring(2), "");
            }
        }
        string2 = string2.trim();
        if (string2.startsWith(",")) {
            string2 = string2.substring(2);
        }
        if (string2.equals("(")) {
            string2 = "";
        }
        this.remarkArea.setText(string2);
    }

    public void printResults(String string) {
        JTextArea jTextArea = new JTextArea(this.formatResults(string.equals("date")));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JFrame jFrame = new JFrame("Report");
        RemarkOMatic.createAndShowGUI(jFrame, jScrollPane, 2);
    }

    public void exportResults() {
        String string = null;
        String string2 = "";
        string = this.getLogfileFolder().equals("null") ? this.getDefaultPath() : this.getLogfileFolder();
        String string3 = JOptionPane.showInputDialog("Where would you like to put the file?", (Object)string);
        if (string3 != null) {
            if (!string3.endsWith(File.separatorChar + "")) {
                string3 = string3 + File.separatorChar;
            }
            string2 = !this.dateField.getText().equals("") ? this.dateField.getText() : (!this.reportDateField.getText().equals("") ? this.reportDateField.getText() : "images");
            String string4 = JOptionPane.showInputDialog("What would you like to call the file?", (Object)("review_" + this.telescopeBox.getSelectedItem() + "_" + string2 + ".txt"));
            if (string4 != null) {
                this.setLogfileFolder(string3);
                this.checkLogfile(string3, string4);
                this.sendToLogfile(this.formatResults(false));
            }
        }
    }

    public void showUnreviewedReport() {
        String string = "";
        String string2 = "" + this.reportTelescopeBox.getSelectedItem();
        try {
            frame.setCursor(this.waitCursor);
            URL uRL = new URL("https://www.aavso.org/vsx/index.php?view=api.img_info&telescope=" + string2);
            NodeList nodeList = this.getDocument(uRL).getElementsByTagName("Entry");
            if (nodeList != null && nodeList.getLength() > 0) {
                Object object;
                Object object2;
                string = " " + string2 + "\n\n";
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object2 = nodeList.item(i).getChildNodes();
                    object = (Element)object2.item(0);
                    String string3 = object.getTextContent();
                    Element element = (Element)object2.item(2);
                    String string4 = element.getTextContent();
                    Element element2 = (Element)object2.item(1);
                    String string5 = element2.getTextContent();
                    if (Integer.parseInt(string4) <= 0) continue;
                    string = string + " date: " + string3 + " - " + string4 + " unreviewed out of " + string5 + " records  \n";
                }
                JTextArea jTextArea = new JTextArea(string);
                object2 = new JScrollPane(jTextArea);
                object = new JFrame("Report");
                RemarkOMatic.createAndShowGUI((JFrame)object, (Container)object2, 2);
            } else {
                JOptionPane.showMessageDialog(null, "All of " + string2 + "'s images have been reviewed.", "Report", 1);
            }
            frame.setCursor(this.defaultCursor);
        }
        catch (MalformedURLException malformedURLException) {
            frame.setCursor(this.defaultCursor);
            JOptionPane.showMessageDialog(null, "Exception: " + malformedURLException.getMessage(), "Warning", 0);
        }
    }

    public String getDefaultPath() {
        String string = System.getProperty("os.name");
        if (string.substring(0, 3).equals("Mac")) {
            return System.getProperty("user.home") + File.separatorChar + DEFAULT_MAC_FOLDER + File.separatorChar;
        }
        return System.getProperty("user.home") + File.separatorChar;
    }

    public void checkLogfile(String string, String string2) {
        String string3 = null;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
            JOptionPane.showMessageDialog(null, "New folder created", "Notice", 1);
        }
        if (string2 == null || string2.length() == 0) {
            this.setLogfile(DEFAULT_LOGFILE);
        }
        File file2 = new File(string + string2);
        try {
            if (file2.exists() && file2.canRead()) {
                string3 = JOptionPane.showInputDialog("Your logfile already exists.\nand will be overwritten\nunless you rename it now.", (Object)string2);
                while (string3.equals("")) {
                    string3 = JOptionPane.showInputDialog(null, "Illegal file name, please re-enter:  ", "Invalid File Name", 2);
                }
                this.setLogfile(string3);
            } else {
                this.setLogfile(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendToLogfile(String string) {
        PrintWriter printWriter = null;
        String string2 = this.getLogfileFolder() + this.getLogfile();
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2, false)));
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        printWriter.println(string);
        printWriter.close();
    }

    public void getReviewerInfo() {
        do {
            String string;
            if ((string = JOptionPane.showInputDialog(this, "Reviewer's initials (3 letters):", this.getReviewerInitials())) == null) {
                System.exit(0);
                continue;
            }
            this.setReviewerInitials(string);
        } while (this.getReviewerInitials().equals("") || this.getReviewerInitials() == null);
    }

    public void getUserDefaults(String string) {
        String string2 = this.getDefaultPath() + string;
        try {
            File file = new File(string2);
            if (file.exists() && file.canRead()) {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                this.setLogfileFolder(bufferedReader.readLine());
                String string4 = bufferedReader.readLine();
                if (string4 != null) {
                    this.telescopeBox.setSelectedItem(string4);
                }
                if ((string3 = bufferedReader.readLine()) == null) {
                    this.setReviewerInitials("");
                } else {
                    this.setReviewerInitials(string3);
                }
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUserDefaults() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(this.getDefaultPath() + USER_PREFERENCES_FILE));
            printWriter.println(this.getLogfileFolder());
            printWriter.println(this.getTelescope());
            printWriter.println(this.getReviewerInitials());
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void activateButton(JButton jButton) {
        jButton.setEnabled(true);
        jButton.setSelected(true);
        this.getRootPane().setDefaultButton(jButton);
        jButton.setMnemonic(10);
        if (jButton == this.saveButton) {
            this.saveRangeButton.setEnabled(true);
        }
    }

    public void enableButtons(Boolean bl) {
        this.fakeButton.setSelected(true);
        this.vButton.setEnabled(bl);
        this.hButton.setEnabled(bl);
        this.dButton.setEnabled(bl);
        this.directionSelected = false;
    }

    public void clearFields() {
        this.imageNumberField.setText("");
        this.blankBox.setSelected(false);
        this.cloudsBox.setSelected(false);
        this.cosmicBox.setSelected(false);
        this.donutBox.setSelected(false);
        this.focusBox.setSelected(false);
        this.ghostBox.setSelected(false);
        this.objectBox.setSelected(false);
        this.otherBox.setSelected(false);
        this.saturatedBox.setSelected(false);
        this.gradationBox.setSelected(false);
        this.trailedBox.setSelected(false);
        this.glintBox.setSelected(false);
        this.remarkArea.setText("");
        this.enableButtons(false);
        this.saveButton.setEnabled(false);
        this.saveRangeButton.setEnabled(false);
        this.directionSelected = false;
        this.editRemarkArea.setText("");
        this.editImageNumberField.setText("");
        this.saveEditButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.findButton.setEnabled(false);
    }

    public String getBaseURL() {
        return BASE_URL;
    }

    public void setLogfile(String string) {
        this.logfile = string;
    }

    public String getLogfile() {
        return this.logfile;
    }

    public void setImageNumber(String string) {
        this.imageNumber = string;
    }

    public String getImageNumber() {
        return this.imageNumber;
    }

    public void setTelescope(String string) {
        this.telescope = string;
    }

    public String getTelescope() {
        return this.telescope;
    }

    public void setRecordDate(String string) {
        this.recordDate = string;
    }

    public String getRecordDate() {
        return this.recordDate;
    }

    public void setLogfileFolder(String string) {
        this.logfileFolder = string;
    }

    public String getLogfileFolder() {
        return this.logfileFolder;
    }

    public void setReviewerInitials(String string) {
        this.reviewerInitials = string;
    }

    public String getReviewerInitials() {
        return this.reviewerInitials;
    }

    public String getRemarkAreaText() {
        return this.remarkArea.getText();
    }

    public void setRemarkAreaText(String string) {
        this.remarkArea.setText(string);
    }

    public void setTelescopeName(int n, String string) {
        this.telescopeName[n] = string;
    }

    public void setDateNumber(int n, String string) {
        this.dateNumber[n] = string;
    }

    public void setFilename(int n, String string) {
        this.filename[n] = string;
    }

    public void setObject(int n, String string) {
        this.object[n] = string;
    }

    public void setFilter(int n, String string) {
        this.filter[n] = string;
    }

    public void setExptime(int n, String string) {
        this.exptime[n] = string;
    }

    public void setComments(int n, String string) {
        this.comments[n] = string;
    }

    public void setReviewer(int n, String string) {
        this.reviewer[n] = string;
    }

    public String getTelescopeName(int n) {
        return this.telescopeName[n];
    }

    public String getDateNumber(int n) {
        return this.dateNumber[n];
    }

    public String getFilename(int n) {
        return this.filename[n];
    }

    public String getObject(int n) {
        return this.object[n];
    }

    public String getFilter(int n) {
        return this.filter[n];
    }

    public String getExptime(int n) {
        return this.exptime[n];
    }

    public String getComments(int n) {
        return this.comments[n];
    }

    public String getReviewer(int n) {
        return this.reviewer[n];
    }

    private static void createAndShowGUI(JFrame jFrame, Container container, int n) {
        jFrame.setDefaultCloseOperation(n);
        jFrame.setContentPane(container);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static void createAndShowGUI() {
        frame = new JFrame("Remark-O-Matic - 2.1.1");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(0);
        RemarkOMatic remarkOMatic = new RemarkOMatic();
        remarkOMatic.setOpaque(true);
        frame.setContentPane(remarkOMatic);
        frame.addWindowListener(remarkOMatic);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RemarkOMatic.createAndShowGUI();
            }
        });
    }
}

