/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.DataConnector;
import AAVSOtools.GBC;
import AAVSOtools.Zapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorSelector
extends JFrame
implements ActionListener {
    private static final double FRAME_WDTH_FACTOR = 0.3;
    private static final double FRAME_HT_FACTOR = 0.8;
    private static final int X_LOC = 5;
    private static final int Y_LOC = 5;
    private String[] seriesText;
    private JButton[] colorButton;
    private JLabel[] seriesLabel;
    private Color[] color;
    private Color[] savedColor;
    private JLabel titleLabel;
    private int colorArraySize;
    private JButton zapperColorsButton = new JButton();
    private JButton lcgColorsButton = new JButton();
    private JButton previewButton = new JButton();
    private JButton resetButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton saveButton = new JButton();
    private JColorChooser tcc;
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private Zapper zapper;
    private DataConnector db;

    public ColorSelector(Zapper zapper, DataConnector dataConnector, Color[] colorArray, int n) {
        this.zapper = zapper;
        this.db = dataConnector;
        this.setTitle("Color Chooser");
        this.setColorArraySize(n);
        this.seriesText = new String[this.getColorArraySize()];
        this.colorButton = new JButton[this.getColorArraySize()];
        this.seriesLabel = new JLabel[this.getColorArraySize()];
        this.color = new Color[this.getColorArraySize()];
        this.color = colorArray;
        this.savedColor = new Color[this.getColorArraySize()];
        this.setSize((int)(this.dim.getWidth() * 0.3), (int)(this.dim.getHeight() * 0.8));
        this.setLocation(5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel("  Click on a color to change it:"), new GBC(0, 0, 2, 1).setFill(2).setWeight(100.0, 0.0));
        JPanel jPanel3 = new JPanel(new GridLayout((this.getColorArraySize() - 5) / 3, 3));
        for (int i = 0; i < this.getColorArraySize() - 5; ++i) {
            this.colorButton[i] = new JButton();
            jPanel3.add(this.setupButton(this.colorButton[i], this.getLabel(i), zapper.getPlotColor(i)));
        }
        JPanel jPanel4 = new JPanel(new GridLayout(3, 2));
        for (int i = this.getColorArraySize() - 5; i < this.getColorArraySize(); ++i) {
            this.colorButton[i] = new JButton();
            jPanel4.add(this.setupButton(this.colorButton[i], this.getLabel(i), zapper.getPlotColor(i)));
        }
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.saveButton);
        jPanel5.add((Component)this.setupButton(this.zapperColorsButton, "Zapper Colors", Color.WHITE), new GBC(0, 0, 1, 1).setFill(2).setWeight(100.0, 0.0));
        jPanel5.add((Component)this.setupButton(this.lcgColorsButton, "White Background Colors", Color.WHITE), new GBC(0, 1, 1, 1).setFill(2).setWeight(100.0, 0.0));
        jPanel5.add((Component)this.setupButton(this.previewButton, "Preview", Color.WHITE), new GBC(0, 2, 1, 1).setFill(2).setWeight(100.0, 0.0));
        jPanel5.add((Component)this.setupButton(this.resetButton, "Reset", Color.WHITE), new GBC(1, 0, 1, 1).setFill(2).setWeight(100.0, 0.0));
        jPanel5.add((Component)this.setupButton(this.cancelButton, "Cancel", Color.WHITE), new GBC(1, 1, 1, 1).setFill(2).setWeight(100.0, 0.0));
        jPanel5.add((Component)this.setupButton(this.saveButton, "Save", Color.WHITE), new GBC(1, 2, 1, 1).setFill(2).setWeight(100.0, 0.0));
        jPanel.add((Component)jPanel2, new GBC(0, 0, 1, 1).setFill(2).setWeight(100.0, 0.0).setInsets(2, 5, 5, 5));
        jPanel.add((Component)jPanel3, new GBC(0, 1, 1, 1).setFill(2).setWeight(100.0, 0.0).setInsets(2, 5, 5, 5));
        jPanel.add((Component)jPanel4, new GBC(0, 2, 1, 1).setFill(2).setWeight(100.0, 0.0).setInsets(2, 5, 20, 5));
        jPanel.add((Component)jPanel5, new GBC(0, 3, 1, 1).setFill(2).setWeight(100.0, 0.0).setInsets(2, 5, 5, 5));
        this.add(jPanel);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public JButton setupButton(JButton jButton, String string, Color color) {
        jButton.setText(string);
        jButton.setFont(new Font("Ariel", 0, 10));
        jButton.addActionListener(this);
        if (color != null) {
            jButton.setBackground(color);
        }
        return jButton;
    }

    public String getLabel(int n) {
        if (n < this.getColorArraySize() - 5) {
            return this.db.getDescription(n);
        }
        if (n == this.getColorArraySize() - 5) {
            return "fainter-than";
        }
        if (n == this.getColorArraySize() - 4) {
            return "discrepant";
        }
        if (n == this.getColorArraySize() - 3) {
            return "flagged observer";
        }
        if (n == this.getColorArraySize() - 2) {
            return "background";
        }
        if (n == this.getColorArraySize() - 1) {
            return "crosshairs";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        int n;
        for (n = 0; n < this.getColorArraySize(); ++n) {
            color = null;
            if (actionEvent.getSource() == this.colorButton[n]) {
                color = JColorChooser.showDialog(this, "Choose Data Type Color", this.colorButton[n].getBackground());
            }
            if (color == null) continue;
            this.colorButton[n].setBackground(color);
            this.getRootPane().setDefaultButton(this.saveButton);
        }
        if (actionEvent.getSource() == this.zapperColorsButton) {
            this.zapper.setDefaultZapperColors();
            for (n = 0; n < this.getColorArraySize(); ++n) {
                this.colorButton[n].setBackground(this.zapper.getPlotColor(n));
            }
            this.getRootPane().setDefaultButton(this.saveButton);
        }
        if (actionEvent.getSource() == this.lcgColorsButton) {
            this.zapper.setDefaultLCGColors();
            for (n = 0; n < this.getColorArraySize(); ++n) {
                this.colorButton[n].setBackground(this.zapper.getPlotColor(n));
            }
            this.getRootPane().setDefaultButton(this.saveButton);
        }
        if (actionEvent.getSource() == this.previewButton) {
            for (n = 0; n < this.getColorArraySize(); ++n) {
                this.zapper.setPlotColor(n, this.colorButton[n].getBackground());
                this.color[n] = this.colorButton[n].getBackground();
            }
            this.zapper.setPreferredColors();
        }
        if (actionEvent.getSource() == this.resetButton) {
            for (n = 0; n < this.getColorArraySize(); ++n) {
                color = this.zapper.getSavedColor(n);
                this.colorButton[n].setBackground(color);
                this.zapper.setPlotColor(n, color);
                this.color[n] = color;
            }
            this.zapper.setPreferredColors();
        }
        if (actionEvent.getSource() == this.cancelButton) {
            for (n = 0; n < this.getColorArraySize(); ++n) {
                color = this.zapper.getSavedColor(n);
                this.colorButton[n].setBackground(color);
                this.zapper.setPlotColor(n, color);
                this.color[n] = color;
            }
            this.zapper.setPreferredColors();
            this.dispose();
        }
        if (actionEvent.getSource() == this.saveButton) {
            for (n = 0; n < this.getColorArraySize(); ++n) {
                this.zapper.setPlotColor(n, this.colorButton[n].getBackground());
                this.color[n] = this.colorButton[n].getBackground();
            }
            this.zapper.setPreferredColors();
            this.zapper.setUserDefaults(this.color);
            this.dispose();
        }
    }

    public void setColorArraySize(int n) {
        this.colorArraySize = n;
    }

    public int getColorArraySize() {
        return this.colorArraySize;
    }
}

