/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.EnterStar;
import AAVSOtools.JDCalculator;
import AAVSOtools.Observation;
import AAVSOtools.ProgBar;
import AAVSOtools.UserInfo;
import AAVSOtools.Zapper;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataConnector
extends AbstractXYDataset
implements XYDataset,
DomainInfo,
RangeInfo,
PropertyChangeListener {
    private static final int MAX_RECORD_COUNT = 30000;
    private static final int DEFAULT_MAX_DUPS = 10;
    private static final int DEFAULT_SERIES_COUNT = 50;
    private static final int DEFAULT_DOT_SIZE = 2;
    private static final Double DEFAULT_MIN_JD = 9999999.0;
    private static final Double DEFAULT_MAX_JD = 0.0;
    private static final Double DEFAULT_MIN_MAG = 100.0;
    private static final Double DEFAULT_MAX_MAG = -100.0;
    private static final int VECTOR_SIZE = 40;
    private static final String BASE_URL = "https://www.aavso.org/vsx/index.php?view=";
    private static final String USER_DEFAULTS_FILE = "myZapperDefaults.ini";
    private static final String DEFAULT_MAC_FOLDER = "/Documents/";
    private static final String DEFAULT_EDITOR_NAME = "";
    private static final String DEFAULT_LOGFILE = "zapperLog.fil";
    private static final String DEFAULT_STAR = "";
    private static final String DEFAULT_STARTDATE = "2457000";
    private static final String DEFAULT_ENDDATE = "9999999";
    private int itemCount;
    private int seriesCount;
    private int totalCount;
    private int oldTotalCount;
    private int editorFid;
    private int page;
    private int bandToConnect;
    private int[] obscodeArray;
    private int[] recordArray;
    private int[] series;
    private Double minJd;
    private Double maxJd;
    private Double minMag;
    private Double maxMag;
    private Double[][] jdPlot;
    private Double[][] magnitudePlot;
    private String auid;
    private String desig;
    private String editorName;
    private String editorObscode;
    private String endDate = null;
    private String lastEndDate = null;
    private String lastJDEnd = null;
    private String lastJDStart = null;
    private String lastStarname = null;
    private String lastStartDate = null;
    private String path;
    private String observerToFlag = null;
    private String previousObserverToFlag = null;
    private String star = null;
    private String startDate = null;
    private String varType = null;
    private String specType = null;
    private String period = null;
    private String vsxStar = null;
    private String magMax = null;
    private String magMin = null;
    private String memId;
    private String[] editorComments;
    private int bandCount;
    private int numberOfBandsUsed;
    private int[] bandCode;
    private String[] description;
    private String[] bandShortName;
    private int[] r_color;
    private int[] g_color;
    private int[] b_color;
    private Vector<Integer> legendBand = new Vector(40);
    private Boolean datalogStatus = false;
    private Boolean cancelSelected = false;
    private Boolean showDiscrepant = false;
    private Boolean showObs = false;
    private Boolean showMyObs = false;
    private Number domainMax;
    private Number domainMin;
    private Number rangeMax;
    private Number rangeMin;
    private DecimalFormat dateFormat = new DecimalFormat("0.0###");
    private Range domainRange;
    private Range range;
    private static DataConnector stardataset = null;
    public EnterStar starWindow = null;
    private Frame frame;
    public UserInfo info;
    private JDCalculator jcal;
    private Zapper zapper;
    private ProgBar pb;
    private ArrayList<Observation> data;
    private ArrayList<Observation> oldData;
    private Task task;

    public DataConnector(Zapper zapper, ArrayList<Observation> arrayList) {
        this(zapper, arrayList, 50, 30000);
    }

    public DataConnector(Zapper zapper, ArrayList<Observation> arrayList, int n, int n2) {
        this.zapper = zapper;
        this.zapper.setFrameVisibility(false);
        this.data = arrayList;
        this.loadBandsTable();
        this.getUserDefaults();
        this.getUserInfo();
        this.getData(false);
        if (this.getCancelSelected().booleanValue()) {
            System.exit(0);
        }
    }

    public void getUserDefaults() {
        String string = this.getPathToFile(this.getUserDefaultsFilename());
        try {
            File file = new File(string);
            if (file.exists() && file.canRead()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                this.setEditorName(bufferedReader.readLine());
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "FileNotFoundException: " + fileNotFoundException.getMessage(), "Warning", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Exception: " + exception.getMessage(), "Warning", 0);
        }
    }

    public String getPathToFile(String string) {
        String string2 = System.getProperty("os.name");
        if (string2.substring(0, 3).equals("Mac")) {
            return System.getProperty("user.home") + File.separatorChar + this.getDefaultMacFolder() + string;
        }
        return System.getProperty("user.home") + File.separatorChar + string;
    }

    public void getUserInfo() {
        this.info = new UserInfo(this.frame, this, this.zapper);
    }

    public void initializeArrays(int n, int n2) {
        this.jdPlot = new Double[n][n2];
        this.magnitudePlot = new Double[n][n2];
        this.series = new int[n2];
        this.obscodeArray = new int[n2];
        this.recordArray = new int[10];
        this.editorComments = new String[n2];
        this.seriesCount = n;
        this.itemCount = n2;
        this.resetAxisValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(URL uRL) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(uRL.openStream());
            document.getDocumentElement().normalize();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            JOptionPane.showMessageDialog(null, "There is a problem with the data for this star.\n" + exception.getMessage() + "\nPlease contact AAVSO HQ and let us know the name of the star and the date range\nyou requested so we can fix it", "Warning", 0);
            this.getData(false);
        }
        return document;
    }

    public int postCommand(String string, String string2) {
        int n = 0;
        try {
            URL uRL = new URL(string);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Accept", "application/xml");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            n = httpsURLConnection.getResponseCode();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
        }
        return n;
    }

    public String getObscodeFromProfile() {
        try {
            URL uRL = new URL("https://www.aavso.org/vsx/index.php?view=api.member&id=" + this.getMemId());
            NodeList nodeList = this.getDocument(uRL).getElementsByTagName("Member");
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            Element element = (Element)nodeList2.item(0);
            String string = element.getTextContent();
            if (string != null) {
                String string2 = string;
                return string2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
        return "no AAVSO obscode";
    }

    public void getData(Boolean bl) {
        this.setCancelSelected(false);
        Double d = this.getTodaysJD();
        Integer n = d.intValue();
        this.starWindow = this.getStar() != null ? new EnterStar(this, this.frame, this.getStar(), this.lastStartDate, this.lastEndDate, bl) : new EnterStar(this, this.frame, "", n - 720 + "", n + 1 + "", false);
        if (!this.getCancelSelected().booleanValue()) {
            this.pb = new ProgBar(this, "   Loading data for " + this.getStar() + "...", (Boolean)true);
            this.pb.setVisible(true);
            this.pb.setIndeterminate(true);
            this.task = new Task();
            this.task.addPropertyChangeListener(this);
            this.task.execute();
        }
    }

    public Boolean isDataLoadFinished() {
        if (this.task.isDone()) {
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("progress" == propertyChangeEvent.getPropertyName()) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.pb.setIndeterminate(false);
            this.pb.setProgress(n);
        }
        if ("succeeded" == propertyChangeEvent.getPropertyName()) {
            System.out.println("Task succeeded");
        }
        if ("cancelled" == propertyChangeEvent.getPropertyName()) {
            System.out.println("Task cancelled");
        }
    }

    public void setPlotAxes(Observation observation, int n, int n2) {
        this.setJdPlot(n, n2, observation.getJD());
        if (observation.getJD() < this.getMinJd()) {
            this.setMinJd(observation.getJD());
        }
        if (observation.getJD() > this.getMaxJd()) {
            this.setMaxJd(observation.getJD());
        }
        this.setMagnitudePlot(n, n2, observation.getMagnitude());
        if (observation.getMagnitude() < this.getMinMag()) {
            this.setMinMag(observation.getMagnitude() - 0.25);
        }
        if (observation.getMagnitude() > this.getMaxMag()) {
            this.setMaxMag(observation.getMagnitude() + 0.25);
        }
        this.domainMin = new Double(this.getMinJd());
        this.domainMax = new Double(this.getMaxJd());
        this.domainRange = new Range(this.getMinJd(), this.getMaxJd());
        this.rangeMin = new Double(this.getMinMag());
        this.rangeMax = new Double(this.getMaxMag());
        this.range = new Range(this.getMinMag(), this.getMaxMag());
        this.fireDatasetChanged();
    }

    public void logRecord(int n) {
        Observation observation = this.data.get(n);
        try {
            String string = this.getBaseURL() + "api.zapperlog";
            String string2 = "auid=" + URLEncoder.encode(this.getAUID().trim(), "UTF-8") + "&name=" + URLEncoder.encode(this.getStar().trim(), "UTF-8") + "&unique_id=" + observation.getUnique_id() + "&editor=" + URLEncoder.encode(this.getEditorName().trim(), "UTF-8") + "&editdate=" + this.getTodaysJD() + "&editorcomments=" + URLEncoder.encode(this.getEditorComments(n).trim(), "UTF-8");
            int n2 = this.postCommand(string, string2);
            this.sendToLogfile("Observation Zapped: Starname: " + this.getStar() + ", AUID: " + this.getAUID() + ", Unique_id: " + observation.getUnique_id() + ", Comments: " + this.getEditorComments(n));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, "Record not sent. Please contact AAVSO HQ.", "Error!", 2);
        }
    }

    public void loadBandsTable() {
        try {
            URL uRL = new URL("https://www.aavso.org/vsx/index.php?view=api.bands");
            NodeList nodeList = this.getDocument(uRL).getElementsByTagName("Band");
            this.setBandCount(nodeList.getLength());
            int n = this.getBandCount();
            this.zapper.setColorArraySize(n + 5);
            this.zapper.setObsIndex(n + 2);
            this.zapper.setBgIndex(n + 3);
            this.zapper.setChIndex(n + 4);
            this.bandCode = new int[n];
            this.description = new String[n];
            this.bandShortName = new String[n];
            this.r_color = new int[n];
            this.g_color = new int[n];
            this.b_color = new int[n];
            for (int i = 0; i < n; ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < 6; ++j) {
                    Element element = (Element)nodeList2.item(j);
                    String string = element.getNodeName();
                    String string2 = element.getTextContent();
                    if ("Code".equals(string)) {
                        this.setBandCode(i, Integer.parseInt(string2));
                        continue;
                    }
                    if ("Description".equals(string + "")) {
                        this.setDescription(i, string2);
                        continue;
                    }
                    if ("ShortName".equals(string + "")) {
                        this.setBandShortName(i, string2);
                        continue;
                    }
                    if ("RColor".equals(string)) {
                        this.setR_color(i, Integer.parseInt(string2));
                        continue;
                    }
                    if ("GColor".equals(string)) {
                        this.setG_color(i, Integer.parseInt(string2));
                        continue;
                    }
                    if (!"BColor".equals(string)) continue;
                    this.setB_color(i, Integer.parseInt(string2));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public int getBandCodeFromBandString(String string) {
        for (int i = 0; i < this.getBandCount(); ++i) {
            if (!string.equals(this.bandShortName[i])) continue;
            return this.bandCode[i];
        }
        return 1;
    }

    public void plotNextStar(String string, Boolean bl) {
        String string2 = this.getDefaultStartDate();
        String string3 = this.getDefaultEndDate();
        this.setLastStarname(string);
        this.setLastStartDate(string2);
        this.setLastEndDate(string3);
        this.getData(bl);
        if (this.getShowObs().booleanValue()) {
            this.zapper.checkForSelectedObserver(this.getObserverToFlag());
            this.zapper.setPreferredColors();
        }
    }

    public double stringToDouble(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("String was null");
        }
        try {
            if (string.contains(",")) {
                string = string.replace(",", ".");
            }
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(numberFormatException.getLocalizedMessage());
        }
    }

    public void updateSeriesNumber(int n, int n2) {
        Observation observation = this.data.get(n);
        int n3 = this.assignSeriesNumber(observation.getFainterthan(), observation.getBand(), observation.getValflag(), observation.getObscode());
        if (!this.getShowObs().booleanValue()) {
            this.setJdPlot(n2, n, null);
            this.setMagnitudePlot(n2, n, null);
            observation.setSeries(n3);
            this.setJdPlot(observation.getSeries(), n, observation.getJD());
            this.setMagnitudePlot(observation.getSeries(), n, observation.getMagnitude());
        } else {
            observation.setSeries(n3);
            this.setJdPlot(observation.getSeries(), n, observation.getJD());
            this.setMagnitudePlot(observation.getSeries(), n, observation.getMagnitude());
            this.fireDatasetChanged();
        }
    }

    public void toggleValflag(String string, int n, int n2) {
        Observation observation = this.data.get(n);
        if (string.equals("V") || string.equals("Z") || string.equals("") || string == null || string.equals("U") || string.equals("N")) {
            observation.setValflag("T");
        } else if (string.equals("T")) {
            observation.setValflag("V");
        }
        this.updateSeriesNumber(n, n2);
        this.fireDatasetChanged();
        this.zapper.setPreferredColors();
    }

    public int assignSeriesNumber(int n, int n2, String string, String string2) {
        if (string2.equals(this.getObserverToFlag())) {
            return this.getBandCount() + 2;
        }
        if (string.equals("T")) {
            return this.getBandCount() + 1;
        }
        if (!string.equals("T") && n == 1) {
            return this.getBandCount();
        }
        for (int i = 0; i < this.getBandCount(); ++i) {
            if (n2 != this.getBandCode(i)) continue;
            return i;
        }
        return 0;
    }

    public void resetAxisValues() {
        this.minJd = DEFAULT_MIN_JD;
        this.maxJd = DEFAULT_MAX_JD;
        this.minMag = DEFAULT_MIN_MAG;
        this.maxMag = DEFAULT_MAX_MAG;
    }

    public String getEditorComments(int n) {
        if (this.editorComments[n] == null || this.editorComments[n].equals("")) {
            return "";
        }
        return this.editorComments[n];
    }

    public int getFainterthanInt(String string) {
        if (string.equals("<")) {
            return 1;
        }
        if (string.equals(">")) {
            return 2;
        }
        return 0;
    }

    public String getFainterthanString(int n) {
        if (n == 1) {
            return "<";
        }
        if (n == 2) {
            return ">";
        }
        return "";
    }

    public String getTransformedString(int n) {
        if (n == 1) {
            return "Yes";
        }
        return null;
    }

    public String getChartString(String string) {
        if (string == null) {
            return "(unspecified)";
        }
        return string;
    }

    public String getCommentString(String string) {
        if (string == null) {
            return "(none)";
        }
        return string;
    }

    public void datasetChanged() {
        this.fireDatasetChanged();
    }

    public int[] getRecordNumbers(double d, double d2) {
        int n = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            Observation observation = this.data.get(i);
            if (d != observation.getJD() || d2 != observation.getMagnitude()) continue;
            this.recordArray[++n] = i;
        }
        return this.recordArray;
    }

    @Override
    public Comparable getSeriesKey(int n) {
        for (int i = 0; i < this.getBandCount(); ++i) {
            if (n != i || !this.legendBand.contains(this.getBandCode(i))) continue;
            return this.getBandShortName(i);
        }
        if (n == this.getBandCount()) {
            return "fainter-than  ";
        }
        if (n == this.getBandCount() + 1) {
            return "discrepant";
        }
        if (this.getShowObs().booleanValue() && n == this.getBandCount() + 2) {
            return "observer";
        }
        return "";
    }

    public double getTodaysJD() {
        Calendar calendar = Calendar.getInstance();
        JDCalculator jDCalculator = new JDCalculator();
        double d = this.stringToDouble(this.dateFormat.format((double)calendar.get(5) + (double)calendar.get(11) / 24.0 + (double)calendar.get(12) / 1440.0));
        return jDCalculator.calendarToJD(calendar.get(1), calendar.get(2) + 1, d);
    }

    public int getUncertainInt(String string) {
        if (string.equals(":")) {
            return 1;
        }
        return 0;
    }

    public String getUncertainString(int n) {
        if (n == 1) {
            return ":";
        }
        return "";
    }

    public String getValflagString(String string) {
        if (string.equals("Z") || string.equals("z") || string.equals("") || string == null || string.equals("U") || string.equals("N")) {
            return "un-validated";
        }
        if (string.equals("Q")) {
            return "questionable";
        }
        if (string.equals("T")) {
            return "discrepant";
        }
        return "validated";
    }

    @Override
    public Number getX(int n, int n2) {
        return this.getJdPlot(n, n2);
    }

    @Override
    public Number getY(int n, int n2) {
        return this.getMagnitudePlot(n, n2);
    }

    public void sendToLogfile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.getPathToFile(DEFAULT_LOGFILE), true)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.println(string);
        printWriter.close();
    }

    public void setLegendBand(int n) {
        if (!this.legendBand.contains(n)) {
            this.legendBand.addElement(n);
            this.setNumberOfBandsUsed(this.legendBand.size());
        }
    }

    @Override
    public Range getDomainBounds(boolean bl) {
        return this.domainRange;
    }

    @Override
    public double getDomainLowerBound(boolean bl) {
        return this.domainMin.doubleValue();
    }

    @Override
    public double getDomainUpperBound(boolean bl) {
        return this.domainMax.doubleValue();
    }

    @Override
    public Range getRangeBounds(boolean bl) {
        return this.range;
    }

    public Range getValueRange() {
        return this.range;
    }

    public double getRangeLowerBound() {
        return this.rangeMin.doubleValue();
    }

    @Override
    public double getRangeLowerBound(boolean bl) {
        return this.rangeMin.doubleValue();
    }

    public double getRangeUpperBound() {
        return this.rangeMax.doubleValue();
    }

    @Override
    public double getRangeUpperBound(boolean bl) {
        return this.rangeMax.doubleValue();
    }

    public String getStar() {
        return this.star;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getDefaultStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getDefaultEndDate() {
        return this.endDate;
    }

    public String getLastStarname() {
        return this.lastStarname;
    }

    public String getLastJDStart() {
        return this.lastJDStart;
    }

    public String getLastJDEnd() {
        return this.lastJDEnd;
    }

    public String getObserverToFlag() {
        return this.observerToFlag;
    }

    public String getPreviousObserverToFlag() {
        return this.previousObserverToFlag;
    }

    public String getObsKey(String string) {
        return string + ".unique_id";
    }

    public Boolean getCancelSelected() {
        return this.cancelSelected;
    }

    public String getUserDefaultsFilename() {
        return USER_DEFAULTS_FILE;
    }

    public String getDefaultMacFolder() {
        return DEFAULT_MAC_FOLDER;
    }

    public String getEditorName() {
        return this.editorName;
    }

    public String getEditorObscode() {
        return this.editorObscode;
    }

    public int getDefaultItemCount() {
        return 30000;
    }

    @Override
    public int getItemCount(int n) {
        return this.itemCount;
    }

    @Override
    public int getSeriesCount() {
        return this.seriesCount;
    }

    public Double getJdPlot(int n, int n2) {
        return this.jdPlot[n][n2];
    }

    public Double getMagnitudePlot(int n, int n2) {
        return this.magnitudePlot[n][n2];
    }

    public int getLegendBand(int n) {
        return this.legendBand.elementAt(n);
    }

    public int getNumberOfBandsUsed() {
        return this.numberOfBandsUsed;
    }

    public int getBandToConnect() {
        return this.bandToConnect;
    }

    public String getMemId() {
        return this.memId;
    }

    public String getAUID() {
        return this.auid;
    }

    public Boolean getShowObs() {
        return this.showObs;
    }

    public Boolean getShowMyObs() {
        return this.showMyObs;
    }

    public int getBandCount() {
        return this.bandCount;
    }

    public int getBandCode(int n) {
        return this.bandCode[n];
    }

    public String getDescription(int n) {
        return this.description[n];
    }

    public String getBandShortName(int n) {
        return this.bandShortName[n];
    }

    public int getR_color(int n) {
        return this.r_color[n];
    }

    public int getG_color(int n) {
        return this.g_color[n];
    }

    public int getB_color(int n) {
        return this.b_color[n];
    }

    public String getVsxStar() {
        return this.vsxStar;
    }

    public String getVarType() {
        return this.varType;
    }

    public String getPeriod() {
        return this.period;
    }

    public String getSpecType() {
        return this.specType;
    }

    public String getMagMin() {
        return this.magMin;
    }

    public String getMagMax() {
        return this.magMax;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getOldTotalCount() {
        return this.oldTotalCount;
    }

    public String getBaseURL() {
        return BASE_URL;
    }

    private Double getMinJd() {
        return this.minJd;
    }

    private Double getMaxJd() {
        return this.maxJd;
    }

    private Double getMinMag() {
        return this.minMag;
    }

    private Double getMaxMag() {
        return this.maxMag;
    }

    public void setProgressVisibility(Boolean bl) {
        if (bl.booleanValue()) {
            this.pb.setVisible(true);
        } else {
            this.pb.closeProgressBar();
        }
    }

    public void setAUID(String string) {
        this.auid = string;
    }

    public void setDesig(String string) {
        this.desig = string;
    }

    public void setEditorComments(int n, String string) {
        this.editorComments[n] = string;
    }

    public void setJdPlot(int n, int n2, Double d) {
        this.jdPlot[n][n2] = d;
    }

    public void setMagnitudePlot(int n, int n2, Double d) {
        this.magnitudePlot[n][n2] = d;
    }

    public void setMemId(String string) {
        this.memId = string;
    }

    public void setNumberOfBandsUsed(int n) {
        this.numberOfBandsUsed = n;
    }

    public void setBandToConnect(int n) {
        this.bandToConnect = n;
    }

    public void setShowObs(Boolean bl) {
        this.showObs = bl;
    }

    public void setShowMyObs(Boolean bl) {
        this.showMyObs = bl;
    }

    public void setCancelSelected(Boolean bl) {
        this.cancelSelected = bl;
    }

    public void setBandCount(int n) {
        this.bandCount = n;
    }

    public void setBandCode(int n, int n2) {
        this.bandCode[n] = n2;
    }

    public void setDescription(int n, String string) {
        this.description[n] = string;
    }

    public void setBandShortName(int n, String string) {
        this.bandShortName[n] = string;
    }

    public void setR_color(int n, int n2) {
        this.r_color[n] = n2;
    }

    public void setG_color(int n, int n2) {
        this.g_color[n] = n2;
    }

    public void setB_color(int n, int n2) {
        this.b_color[n] = n2;
    }

    public void setVsxStar(String string) {
        this.vsxStar = string;
    }

    public void setVarType(String string) {
        this.varType = string;
    }

    public void setPeriod(String string) {
        this.period = string;
    }

    public void setSpecType(String string) {
        this.specType = string;
    }

    public void setMagMin(String string) {
        this.magMin = string;
    }

    public void setMagMax(String string) {
        this.magMax = string;
    }

    private void setMinJd(Double d) {
        this.minJd = d;
    }

    private void setMaxJd(Double d) {
        this.maxJd = d;
    }

    private void setMinMag(Double d) {
        this.minMag = d;
    }

    private void setMaxMag(Double d) {
        this.maxMag = d;
    }

    public void setEditorName(String string) {
        this.editorName = string;
    }

    public void setEditorObscode(String string) {
        this.editorObscode = string;
    }

    public void setEndDate(String string) {
        this.endDate = string;
    }

    public void setLastStarname(String string) {
        this.lastStarname = string;
    }

    public void setLastStartDate(String string) {
        this.lastStartDate = string;
    }

    public void setLastEndDate(String string) {
        this.lastEndDate = string;
    }

    public void setStar(String string) {
        this.star = string;
    }

    public void setStartDate(String string) {
        this.startDate = string;
    }

    public void setObserverToFlag(String string) {
        this.observerToFlag = string;
    }

    public void setPreviousObserverToFlag(String string) {
        this.previousObserverToFlag = string;
    }

    public void setSeries(int n, int n2) {
        this.series[n] = n2;
    }

    public void setSeriesCount(int n) {
        this.seriesCount = n;
    }

    public void setItemCount(int n) {
        this.itemCount = n;
    }

    public void setTotalCount(int n) {
        this.totalCount = n;
    }

    public void setOldTotalCount(int n) {
        this.oldTotalCount = n;
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void doInBackground() {
            URL uRL = null;
            DataConnector.this.setTotalCount(0);
            DataConnector.this.data.clear();
            int n = 1;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            this.setProgress(0);
            try {
                String string = "https://www.aavso.org/vsx/index.php?view=api.object&ident=" + URLEncoder.encode(DataConnector.this.getStar().trim(), "UTF-8") + "&fromjd=" + URLEncoder.encode(DataConnector.this.getStartDate().trim(), "UTF-8") + "&tojd=" + URLEncoder.encode(DataConnector.this.getEndDate().trim(), "UTF-8") + "&where=mtype%3D0+or+mtype+is+null&data=" + 30000;
                do {
                    Object object;
                    uRL = new URL(string + "&page=" + n);
                    NodeList nodeList = DataConnector.this.getDocument(uRL).getElementsByTagName("Observation");
                    n3 = nodeList.getLength();
                    if (DataConnector.this.getTotalCount() == 0) {
                        NodeList nodeList2 = DataConnector.this.getDocument(uRL).getElementsByTagName("Count");
                        if (nodeList2.getLength() != 0) {
                            object = (Object[])nodeList2.item(0);
                            DataConnector.this.setTotalCount(Integer.parseInt(object.getTextContent()));
                        } else if (n3 != 0) {
                            DataConnector.this.setTotalCount(n3);
                        }
                        if (DataConnector.this.getTotalCount() == 0) {
                            DataConnector.this.pb.setVisible(false);
                            JOptionPane.showMessageDialog(DataConnector.this.frame, "Empty data set. Check starname & date range.\n\nIf you think there should be data on this star and you\ncan't get it, please check the star name in VSX and/or expand\nthe date range. If this still doesn't help, email AAVSO HQ\nwith details. (aavso@aavso.org).\n\n    THANK YOU FOR HELPING!   ", "Data Error!", 2);
                            DataConnector.this.plotNextStar(DataConnector.this.getStar(), true);
                            break;
                        }
                        if (DataConnector.this.getTotalCount() >= 30000) {
                            DataConnector.this.pb.setVisible(false);
                            object = new Object[]{"OK", "Cancel"};
                            int n4 = JOptionPane.showOptionDialog(DataConnector.this.frame, "Large data set!\nYou have just requested a dataset containing " + DataConnector.this.getTotalCount() + " observations!\nAre you sure you want to do this (it might take some time to load)?\nClick \"OK\" to continue or \"Cancel\" to go back", "Warning!", -1, 2, null, (Object[])object, object[0]);
                            if (n4 != 0) {
                                DataConnector.this.setCancelSelected(true);
                                DataConnector.this.plotNextStar(DataConnector.this.getStar(), false);
                                break;
                            }
                            DataConnector.this.pb.setVisible(true);
                        }
                    }
                    if (DataConnector.this.getTotalCount() == 0 || n3 == 0) continue;
                    DataConnector.this.pb.setWaitText("   Loading " + DataConnector.this.getTotalCount() + " observations for " + DataConnector.this.getStar() + "...");
                    for (int i = 0; i < n3; ++i) {
                        int n5;
                        if (n2 + i == 0) {
                            this.getVSXdata(DataConnector.this.getDocument(uRL));
                            DataConnector.this.legendBand.removeAllElements();
                            DataConnector.this.initializeArrays(DataConnector.this.getBandCount() + 3, DataConnector.this.getTotalCount());
                        }
                        object = nodeList.item(i).getChildNodes();
                        Observation observation = new Observation(n2 + i);
                        for (n5 = 0; n5 < object.getLength(); ++n5) {
                            Element element = (Element)object.item(n5);
                            String string2 = element.getNodeName();
                            String string3 = element.getTextContent();
                            if ("Id".equals(string2)) {
                                observation.setUnique_id(Integer.parseInt(string3));
                                continue;
                            }
                            if ("Name".equals(string2)) {
                                observation.setName(string3 + "");
                                continue;
                            }
                            if ("JD".equals(string2)) {
                                observation.setJD(Double.parseDouble(string3));
                                continue;
                            }
                            if ("FainterThan".equals(string2) && string3.equals("true")) {
                                observation.setFainterthan(1);
                                continue;
                            }
                            if ("BrighterThan".equals(string2) && string3.equals("true")) {
                                observation.setFainterthan(3);
                                continue;
                            }
                            if ("Mag".equals(string2)) {
                                observation.setMagnitude(Double.parseDouble(string3));
                                continue;
                            }
                            if ("CommentCode".equals(string2)) {
                                observation.setCommentcode(string3 + "");
                                continue;
                            }
                            if ("ObsCode".equals(string2)) {
                                observation.setObscode(string3 + "");
                                continue;
                            }
                            if ("ValFlag".equals(string2)) {
                                if (string3 == null) {
                                    observation.setValflag("");
                                    continue;
                                }
                                observation.setValflag(string3);
                                continue;
                            }
                            if ("Band".equals(string2)) {
                                observation.setBandString(string3 + "");
                                observation.setBand(DataConnector.this.getBandCodeFromBandString(string3));
                                continue;
                            }
                            if ("Uncertainty".equals(string2)) {
                                observation.setUncertainty(string3 + "");
                                continue;
                            }
                            if ("Comp1".equals(string2)) {
                                observation.setComp1_C(string3 + "");
                                continue;
                            }
                            if ("Charts".equals(string2)) {
                                observation.setCharts(string3 + "");
                                continue;
                            }
                            if ("UncertaintyHQ".equals(string2)) {
                                observation.setUncertaintyhq(string3 + "");
                                continue;
                            }
                            if ("ObsType".equals(string2)) {
                                observation.setObstype(string3);
                                continue;
                            }
                            if ("Comp2".equals(string2)) {
                                observation.setComp2_K(string3 + "");
                                continue;
                            }
                            if ("Software".equals(string2)) {
                                observation.setSoftware(string3 + "");
                                continue;
                            }
                            if ("CMag".equals(string2)) {
                                observation.setCmag(string3 + "");
                                continue;
                            }
                            if ("KMag".equals(string2)) {
                                observation.setKmag(string3 + "");
                                continue;
                            }
                            if ("Group".equals(string2)) {
                                observation.setGroup(string3 + "");
                                continue;
                            }
                            if ("Uncertain".equals(string2) && string3.equals("true")) {
                                observation.setUncertain(1);
                                continue;
                            }
                            if ("HJD".equals(string2)) {
                                observation.setHJD(string3 + "");
                                continue;
                            }
                            if ("Comments".equals(string2)) {
                                observation.setComments(string3 + "");
                                continue;
                            }
                            if ("Airmass".equals(string2)) {
                                observation.setAirmass(string3 + "");
                                continue;
                            }
                            if ("Transformed".equals(string2) && string3.equals("true")) {
                                observation.setTransformed(1);
                                continue;
                            }
                            if ("MType".equals(string2)) {
                                observation.setMtype(string3);
                                continue;
                            }
                            if ("Digitizer".equals(string2)) {
                                observation.setDigitizer(string3 + "");
                                continue;
                            }
                            if ("PubRef".equals(string2)) {
                                observation.setPubref(string3 + "");
                                continue;
                            }
                            if (!"Credit".equals(string2)) continue;
                            observation.setCredit(string3 + "");
                        }
                        n5 = DataConnector.this.assignSeriesNumber(observation.getFainterthan(), observation.getBand(), observation.getValflag(), observation.getObscode());
                        observation.setSeries(n5);
                        DataConnector.this.setLegendBand(observation.getBand());
                        if (!observation.getValflag().equals("T")) {
                            DataConnector.this.setPlotAxes(observation, n5, n2 + i);
                        }
                        DataConnector.this.data.add(observation);
                        int n6 = DataConnector.this.data.size() * 100 / DataConnector.this.getTotalCount();
                        this.setProgress(n6);
                    }
                    n2 += n3;
                    ++n;
                } while (DataConnector.this.getTotalCount() - n2 > 0 && !DataConnector.this.getCancelSelected().booleanValue());
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(null, "MalformedURLException: " + malformedURLException.getMessage(), "Warning", 0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JOptionPane.showMessageDialog(null, "UnsupportedEncodingException: " + unsupportedEncodingException.getMessage(), "Warning", 0);
            }
            finally {
                DataConnector.this.zapper.setPreferredColors();
                DataConnector.this.zapper.setupNewPlot();
                DataConnector.this.zapper.setFrameVisibility(true);
                DataConnector.this.zapper.setVisible(true);
                DataConnector.this.fireDatasetChanged();
            }
            return null;
        }

        public void getVSXdata(Document document) {
            this.clearVSXdata();
            NodeList nodeList = document.getElementsByTagName("VSXObject");
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element = (Element)nodeList2.item(i);
                String string = element.getNodeName();
                String string2 = element.getTextContent();
                if ("Name".equals(string)) {
                    DataConnector.this.setVsxStar(string2);
                    continue;
                }
                if ("AUID".equals(string)) {
                    DataConnector.this.setAUID(string2);
                    continue;
                }
                if ("VariabilityType".equals(string)) {
                    DataConnector.this.setVarType(string2);
                    continue;
                }
                if ("Period".equals(string)) {
                    DataConnector.this.setPeriod(string2 + " days");
                    continue;
                }
                if ("SpectralType".equals(string)) {
                    DataConnector.this.setSpecType(string2);
                    continue;
                }
                if ("MinMag".equals(string)) {
                    DataConnector.this.setMagMin(string2 + "");
                    continue;
                }
                if (!"MaxMag".equals(string)) continue;
                DataConnector.this.setMagMax(string2 + "");
            }
        }

        public void clearVSXdata() {
            DataConnector.this.setVsxStar("");
            DataConnector.this.setAUID("");
            DataConnector.this.setVarType("unknown");
            DataConnector.this.setPeriod("unknown");
            DataConnector.this.setSpecType("unknown");
            DataConnector.this.setMagMin("unknown");
            DataConnector.this.setMagMax("unknown");
        }
    }
}

