/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.DataConnector;
import AAVSOtools.GBC;
import AAVSOtools.JDCalculator;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EnterStar
extends JDialog
implements ActionListener {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 250;
    private String chosenStar;
    private String startDate;
    private String endDate;
    private Boolean cancelSelected = false;
    private JTextField starnameField = new JTextField();
    private JTextField startDateField = new JTextField();
    private JTextField endDateField = new JTextField();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton quitButton = new JButton();
    private Frame frame;
    private DataConnector db;

    public EnterStar(DataConnector dataConnector, Frame frame, String string, String string2, String string3, Boolean bl) {
        this(dataConnector, frame, "Zapper - Request Star", true, string, string2, string3, bl);
    }

    public EnterStar(DataConnector dataConnector, Frame frame, String string, Boolean bl, String string2, String string3, String string4, Boolean bl2) {
        super(frame, "Zapper - Request Star", true);
        this.db = dataConnector;
        this.setSize(300, 250);
        this.setModal(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() / 3.0), (int)(dimension.getHeight() / 3.0));
        Container container = this.getContentPane();
        container.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        container.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("Star: "), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 0));
        jPanel.add((Component)this.setupField(this.starnameField, 15, string2, "Enter the starname", true), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel("<html>Start Date: <font color='gray'>(JD or YYYY/MM/DD)</font></html> "), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 0));
        jPanel2.add((Component)this.setupField(this.startDateField, 15, string3, "Enter the start date", true), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(0, 0, 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)new JLabel("<html>End Date: <font color='gray'>(JD or YYYY/MM/DD)</font></html> "), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 0));
        jPanel3.add((Component)this.setupField(this.endDateField, 15, string4, "Enter the end date", true), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(0, 0, 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.setupButton(this.okButton, "OK", true), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 0));
        jPanel4.add((Component)this.setupButton(this.cancelButton, "Cancel", bl2), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(0, 0, 0, 0));
        jPanel4.add((Component)this.setupButton(this.quitButton, "Quit", true), new GBC(2, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(0, 0, 0, 0));
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)jPanel, new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel5.add((Component)jPanel2, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        jPanel5.add((Component)jPanel3, new GBC(0, 2, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        jPanel5.add((Component)jPanel4, new GBC(0, 3, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        container.add(jPanel5);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public JButton setupButton(JButton jButton, String string, Boolean bl) {
        jButton.addActionListener(this);
        jButton.setMnemonic(10);
        jButton.setText(string);
        jButton.setEnabled(bl);
        return jButton;
    }

    public JTextField setupField(JTextField jTextField, int n, String string, String string2, Boolean bl) {
        jTextField.setColumns(n);
        jTextField.setEditable(bl);
        jTextField.setText(string);
        jTextField.setToolTipText(string2);
        jTextField.setBackground(Color.WHITE);
        jTextField.setHorizontalAlignment(0);
        return jTextField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.db.setCancelSelected(false);
            this.chosenStar = this.starnameField.getText();
            if (this.chosenStar == null) {
                this.chosenStar = JOptionPane.showInputDialog(this.frame, "Please enter the name, designation or AUID of a star:", "Missing Star Name", 2);
                if (this.chosenStar == null) {
                    System.exit(0);
                }
            } else {
                this.starnameField.setText(this.chosenStar);
            }
            this.startDate = this.startDateField.getText();
            if (this.startDate.contains("/")) {
                this.startDate = this.convertToJD(this.startDate) + "";
            }
            if (this.startDate.contains(",")) {
                this.startDate = this.startDate.replace(",", ".");
            }
            while (!this.validateJD(this.startDate)) {
                this.startDate = JOptionPane.showInputDialog(this.frame, "Please enter a valid date (eg: 2450000 or YYYY/MM/DD):", "Missing start date", 2);
                this.startDateField.setText(this.startDate);
            }
            this.endDate = this.endDateField.getText();
            if (this.endDate.contains("/")) {
                this.endDate = this.convertToJD(this.endDate) + "";
            }
            if (this.endDate.contains(",")) {
                this.endDate = this.endDate.replace(",", ".");
            }
            while (!this.validateJD(this.endDate)) {
                this.endDate = JOptionPane.showInputDialog(this.frame, "Please enter a valid date (eg: 2457000 or YYYY/MM/DD):", "Missing end date", 2);
                this.endDateField.setText(this.endDate);
            }
            this.db.setStar(this.chosenStar);
            this.db.setStartDate(this.startDate);
            this.db.setEndDate(this.endDate);
            this.db.sendToLogfile("*** New Star *** " + this.chosenStar + " from " + this.startDate + " to " + this.endDate + " (Current Date: " + this.db.getTodaysJD() + ")");
            this.dispose();
        }
        if (actionEvent.getSource() == this.cancelButton) {
            this.db.setCancelSelected(true);
            this.dispose();
        }
        if (actionEvent.getSource() == this.quitButton) {
            System.exit(0);
        }
    }

    public double convertToJD(String string) {
        String[] stringArray = string.split("/");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        double d = Double.parseDouble(stringArray[2]);
        JDCalculator jDCalculator = new JDCalculator();
        return jDCalculator.calendarToJD(n, n2, d);
    }

    public String removeSpaces(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + stringTokenizer.nextElement();
        }
        return string2;
    }

    public boolean validateJD(String string) {
        String string2 = "0123456789.";
        if (string.length() <= 0 & string.length() > 16) {
            return false;
        }
        char[] cArray = string.toLowerCase().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (string2.indexOf(cArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    public void hideWindow() {
        this.setVisible(false);
    }
}

