/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.DataConnector;
import AAVSOtools.GBC;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgBar
extends JDialog
implements ActionListener {
    private Boolean cancelSelected = false;
    private DataConnector db;
    private JLabel waitLabel;
    private JButton cancelButton;
    private JButton quitButton;
    private JProgressBar progressBar;
    private String cancelText = "Cancel";
    private String quitText = "Quit";

    public ProgBar(DataConnector dataConnector, String string, Boolean bl) {
        this.setTitle("Zapper - Loading Data");
        this.setSize(300, 100);
        this.setAlwaysOnTop(true);
        this.setModal(false);
        this.db = dataConnector;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() / 3.0), (int)(dimension.getHeight() / 3.0));
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(3, 1));
        this.waitLabel = new JLabel();
        this.waitLabel.setText(string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        jPanel.add((Component)this.progressBar, new GBC(0, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 50, 5, 50));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.quitButton = new JButton(this.quitText);
        this.quitButton.addActionListener(this);
        jPanel2.add((Component)this.quitButton, new GBC(0, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 50, 5, 50));
        container.add(this.waitLabel);
        container.add(jPanel);
        container.add(jPanel2);
        this.setDefaultCloseOperation(2);
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.db.setCancelSelected(true);
            this.cancelButton.setEnabled(false);
            this.dispose();
        }
        if (actionEvent.getSource() == this.quitButton) {
            System.exit(0);
        }
    }

    public void setWaitText(String string) {
        this.waitLabel.setText(string);
    }

    public void enableCancelButton(Boolean bl) {
        this.cancelButton.setEnabled(bl);
    }

    public void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    public void setIndeterminate(Boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    public void closeProgressBar() {
        this.dispose();
    }
}

