/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.DataConnector;
import AAVSOtools.GBC;
import AAVSOtools.Zapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UserInfo
extends JDialog
implements ActionListener,
FocusListener {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 225;
    private static final String AUTH_URL = "https://www.aavso.org/apps/api-auth/";
    private JTextField usernameField = new JTextField();
    private JPasswordField passwordField = new JPasswordField();
    private JButton okButton = new JButton();
    private JButton quitButton = new JButton();
    private JButton helpButton = new JButton();
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    private static Frame frame;
    private DataConnector db;
    private Zapper zap;

    public UserInfo(Frame frame, DataConnector dataConnector, Zapper zapper) {
        this(frame, dataConnector, "Zapper - Login", zapper);
    }

    public UserInfo(Frame frame, DataConnector dataConnector, String string, Zapper zapper) {
        super(frame, "Zapper - Login", true);
        this.db = dataConnector;
        this.zap = zapper;
        this.setSize(300, 225);
        this.setModal(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() / 3.0), (int)(dimension.getHeight() / 3.0));
        Container container = this.getContentPane();
        container.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        container.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("Enter your AAVSO Username: "), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 0));
        jPanel.add((Component)this.setupField(this.usernameField, 15, "Enter your AAVSO website username", true), new GBC(0, 2, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(0, 0, 0, 0));
        this.usernameField.setText(this.db.getEditorName());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel("Password: "), new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 0));
        this.passwordField = !this.usernameField.getText().equals("") ? new JPasswordField(){

            @Override
            public void addNotify() {
                super.addNotify();
                this.requestFocusInWindow();
            }
        } : new JPasswordField();
        jPanel2.add((Component)this.setupPasswordField(this.passwordField, 15, "Enter your AAVSO website password", true), new GBC(0, 2, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(0, 0, 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.setupButton(this.okButton, "OK", true), new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5));
        jPanel3.add((Component)this.setupButton(this.quitButton, "Quit", true), new GBC(1, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5));
        jPanel3.add((Component)this.setupButton(this.helpButton, "Help", true), new GBC(2, 0, 1, 1).setWeight(100.0, 0.0).setFill(2).setInsets(5, 0, 0, 5));
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel, new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(11));
        jPanel4.add((Component)jPanel2, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        jPanel4.add((Component)jPanel3, new GBC(0, 2, 1, 1).setWeight(100.0, 0.0).setInsets(5, 5, 5, 5).setFill(2).setAnchor(15));
        container.add(jPanel4);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public JButton setupButton(JButton jButton, String string, Boolean bl) {
        jButton.addActionListener(this);
        jButton.setMnemonic(10);
        jButton.setText(string);
        jButton.setEnabled(bl);
        return jButton;
    }

    public JTextField setupField(JTextField jTextField, int n, String string, Boolean bl) {
        jTextField.setColumns(n);
        jTextField.setEditable(bl);
        jTextField.setToolTipText(string);
        jTextField.setBackground(Color.WHITE);
        jTextField.setHorizontalAlignment(0);
        jTextField.addFocusListener(this);
        return jTextField;
    }

    public JPasswordField setupPasswordField(JPasswordField jPasswordField, int n, String string, Boolean bl) {
        jPasswordField.setColumns(n);
        jPasswordField.setEditable(bl);
        jPasswordField.setToolTipText(string);
        jPasswordField.setBackground(Color.WHITE);
        jPasswordField.setHorizontalAlignment(0);
        jPasswordField.addFocusListener(this);
        return jPasswordField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            String string = null;
            String string2 = null;
            char[] cArray = this.passwordField.getPassword();
            try {
                string = URLEncoder.encode(new String(cArray).trim(), "UTF-8");
                string2 = URLEncoder.encode(this.usernameField.getText().trim(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JOptionPane.showMessageDialog(null, "UnsupportedEncodingException: " + unsupportedEncodingException.getMessage(), "Warning", 0);
            }
            this.authenticate(string2, string);
        }
        if (actionEvent.getSource() == this.helpButton) {
            JOptionPane.showMessageDialog(null, "You must login using your AAVSO website account username and password.\nIf you do not have an account, you can set one up through the AAVSO website:\nhttps://www.aavso.org", "Login Help", 1);
        }
        if (actionEvent.getSource() == this.quitButton) {
            System.exit(0);
        }
    }

    public void authenticate(String string, String string2) {
        try {
            URL uRL = new URL(AUTH_URL);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Accept", "application/xml");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            outputStreamWriter.write("username=" + string + "&password=" + string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            if (httpsURLConnection.getResponseCode() == 200) {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string3);
                }
                String string4 = stringBuffer.toString();
                bufferedReader.close();
                int n = string4.indexOf("<id>") + 4;
                int n2 = string4.indexOf("</id>");
                String string5 = string4.substring(n, n2);
                this.db.setMemId(string5);
                this.db.setEditorObscode(this.db.getObscodeFromProfile());
                this.db.setEditorName(this.usernameField.getText().trim());
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "Invalid username or password.", "Error", 0);
            }
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(null, "MalformedURLException: " + malformedURLException.getMessage(), "Warning", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

