/*
 * Decompiled with CFR 0.152.
 */
package AAVSOtools;

import AAVSOtools.ColorSelector;
import AAVSOtools.DataConnector;
import AAVSOtools.GBC;
import AAVSOtools.Hyperlink;
import AAVSOtools.JDCalculator;
import AAVSOtools.Observation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ShapeUtilities;

public class Zapper
extends JPanel
implements ActionListener,
ChartProgressListener,
ChartMouseListener,
FocusListener,
MouseMotionListener,
MouseListener,
KeyListener,
DocumentListener {
    private static final int DEFAULT_DOTSIZE = 2;
    private static final int MAX_NUMBER_OF_DUPS = 6;
    private static final int MAX_NUMBER_OF_RECORDS = 200000;
    private static final int MAX_NUMBER_OF_ZOOMS = 10;
    private static final int MAX_STAR_COUNT = 11000;
    private static final int X_LOC = 0;
    private static final int Y_LOC = 0;
    private static final Double FRAME_HT_FACTOR = 0.95;
    private static final Double FRAME_WDTH_FACTOR = 1.6;
    private static final Double PLOT_HT_FACTOR = 0.66;
    private static final Double PLOT_WDTH_FACTOR = 1.1;
    private static final String RELEASE_DATE = " (December 8, 2017)";
    private static final String VERSION = "V4.1";
    private static final Color BGCOLOR = new Color(40, 40, 110);
    private static final Color VISCOLOR = new Color(255, 230, 0);
    private static final Color OLIVE = new Color(144, 114, 0);
    private static final Color DARK_ORANGE = new Color(255, 102, 0);
    private static final Color LIGHT_GREEN = new Color(145, 230, 25);
    private static final Color PEACH = new Color(250, 125, 125);
    private static final Color PURPLE = new Color(135, 25, 135);
    public Color[] plotColor;
    public Color[] savedColor;
    private int dotsize = 2;
    private int recordNumber = 0;
    private int seriesNumber = 0;
    private int zoomlevel = 0;
    private int colorArraySize;
    private int bgIndex;
    private int chIndex;
    private int obsIndex;
    private int tryCount = 0;
    private int showObsIndex;
    private int[] dupsArray = new int[6];
    private double crosshairJD = -10.0;
    private double crosshairMag = -10.0;
    private Double[] domainLB = new Double[10];
    private Double[] domainUB = new Double[10];
    private Double[] rangeLB = new Double[10];
    private Double[] rangeUB = new Double[10];
    private String airmassLabel = "   airmass: ";
    private String arrivaldateLabel = "   observation added to archives: ";
    private String auidLabel = " AUID: ";
    private String chartsLabel = " charts: ";
    private String cmagLabel = "   comp #1 magnitude: ";
    private String commentsLabel = " comment: ";
    private String comp1_CLabel = "   comp #1: ";
    private String comp2_KLabel = "   comp #2 or check star: ";
    private String creditLabel = "   credit: ";
    private String groupLabel = "   group: ";
    private String kmagLabel = "   comp #2 magnitude: ";
    private String mtypeLabel = "   magnitude type: ";
    private String softwareLabel = "   software: ";
    private String transformedLabel = "   transformed: ";
    private String uncertaintyhqLabel = "   uncertainty (as calculated by HQ): ";
    private String unique_idLabel = " observation ID: ";
    private Boolean connectObs = true;
    private Boolean controlPressed = false;
    private Boolean mouseClicked = false;
    private Boolean mouseDragged = false;
    private Boolean recordChanged = false;
    private Boolean showObs = false;
    private Boolean showDiscrepant = false;
    private Boolean leftMouseClicked = false;
    private Boolean rightMouseClicked = false;
    private DecimalFormat jdFormat = new DecimalFormat("0.0###");
    private DecimalFormat magFormat = new DecimalFormat("0.0##");
    private JButton backButton = new JButton("\u21e6 BACK");
    private JButton connectMeButton = new JButton("Show My Obs");
    private JButton connectButton = new JButton("Show Observer");
    private JButton forwardButton = new JButton("FORWARD \u21e8");
    private JButton nextstarButton = new JButton("NEXT STAR");
    private JButton quitButton = new JButton("QUIT");
    private JButton resetButton = new JButton("ZOOM OUT");
    private JCheckBox showDiscrepantBox = new JCheckBox();
    private JMenu menuOptions;
    private JMenu preferenceOption;
    private JMenu dotsizeOption;
    private JMenu menuHelp;
    private JMenuItem aboutHelp;
    private JMenuItem colorOption;
    private JMenuItem biggerDotsOption;
    private JMenuItem smallerDotsOption;
    private JMenuItem linesOption;
    private JMenuItem legendOption;
    private JMenuItem onlineHelp;
    private JMenuItem printOption;
    private JMenuItem savePlotOption;
    private JTextArea otherReadout = new JTextArea(5, 1);
    private JTextField bandReadout = new JTextField(7);
    private JTextField commentcodeReadout = new JTextField(5);
    private JTextField countReadout = new JTextField();
    private JTextField dateReadout = new JTextField();
    private JTextField designationReadout = new JTextField(6);
    private JTextField fainterthanReadout = new JTextField(1);
    private JTextField jdReadout = new JTextField(11);
    private JTextField juliandateReadout = new JTextField();
    private JTextField magReadout = new JTextField();
    private JTextField magnitudeReadout = new JTextField(5);
    private JTextField obscodeReadout = new JTextField(8);
    private JTextField obstypeReadout = new JTextField(10);
    private JTextField starnameReadout = new JTextField(15);
    private JTextField uncertainReadout = new JTextField(1);
    private JTextField uncertaintyReadout = new JTextField(4);
    private JTextField validatedReadout = new JTextField(8);
    private static JFrame frame;
    private ValueAxis dAxis;
    private ValueAxis domainAxis;
    private ValueAxis rAxis;
    private ValueAxis rangeAxis;
    private TextTitle mainTitle;
    private TextTitle subTitle;
    private ChartPanel chartPanel;
    private ChartProgressEvent event;
    private ChartRenderingInfo info;
    private ColorSelector colors;
    private Connection connect;
    private Image logo;
    private JFreeChart chart;
    private LegendTitle legend;
    private Rectangle2D dataArea;
    private XYPlot plot;
    ArrayList<Observation> data = new ArrayList();
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    DataConnector db = new DataConnector(this, this.data);
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    JDCalculator date = new JDCalculator();

    public Zapper() {
        int n = (int)(this.dim.getHeight() * FRAME_WDTH_FACTOR) <= (int)this.dim.getWidth() ? (int)(this.dim.getHeight() * FRAME_WDTH_FACTOR) : (int)this.dim.getWidth();
        this.setSize(n, (int)(this.dim.getHeight() * FRAME_HT_FACTOR));
        this.setLocation(((int)this.dim.getWidth() - n) / 2, 0);
        this.setLayout(new GridBagLayout());
        this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.plotColor = new Color[this.getColorArraySize()];
        this.savedColor = new Color[this.getColorArraySize()];
        this.getUserDefaults();
        JMenuBar jMenuBar = new JMenuBar();
        this.menuOptions = new JMenu("Options");
        this.preferenceOption = new JMenu("Preferences..");
        this.preferenceOption.addActionListener(this);
        this.printOption = new JMenuItem("Print plot...");
        this.printOption.addActionListener(this);
        this.savePlotOption = new JMenuItem("Save plot...");
        this.savePlotOption.addActionListener(this);
        this.menuOptions.add(this.preferenceOption);
        this.menuOptions.add(this.printOption);
        this.menuOptions.add(this.savePlotOption);
        this.colorOption = new JMenuItem("Customize colors...");
        this.colorOption.addActionListener(this);
        this.dotsizeOption = new JMenu("Change dot size...");
        this.legendOption = new JMenuItem("Hide legend");
        this.legendOption.addActionListener(this);
        this.preferenceOption.add(this.colorOption);
        this.preferenceOption.add(this.dotsizeOption);
        this.preferenceOption.add(this.legendOption);
        this.biggerDotsOption = new JMenuItem("Make dots bigger");
        this.biggerDotsOption.addActionListener(this);
        this.smallerDotsOption = new JMenuItem("Make dots smaller");
        this.smallerDotsOption.addActionListener(this);
        this.dotsizeOption.add(this.biggerDotsOption);
        this.dotsizeOption.add(this.smallerDotsOption);
        this.menuHelp = new JMenu("Help");
        this.onlineHelp = new JMenuItem("Online help");
        this.aboutHelp = new JMenuItem("About Zapper");
        this.onlineHelp.addActionListener(this);
        this.aboutHelp.addActionListener(this);
        this.menuHelp.add(this.onlineHelp);
        this.menuHelp.add(this.aboutHelp);
        jMenuBar.add(this.menuOptions);
        jMenuBar.add(this.menuHelp);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.setupButton(this.resetButton, "Zoom back out a step"), new GBC(0, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(50, 0, 2, 5));
        jPanel.add((Component)this.setupButton(this.backButton, "Pan backward in time"), new GBC(0, 1, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 2, 5));
        jPanel.add((Component)this.setupButton(this.forwardButton, "Pan forward in time"), new GBC(0, 2, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 20, 5));
        jPanel.add((Component)this.setupButton(this.nextstarButton, "Click to select another star"), new GBC(0, 3, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 20, 5));
        jPanel.add((Component)this.setupButton(this.connectButton, "Highlight the observations of a selected observer"), new GBC(0, 4, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 2, 5));
        jPanel.add((Component)this.setupButton(this.connectMeButton, "Highlight your own observations"), new GBC(0, 5, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 2, 5));
        jPanel.add((Component)this.setupButton(this.quitButton, "Click to quit session"), new GBC(0, 7, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(20, 0, 0, 5));
        jPanel.add((Component)new JLabel("Show:"), new GBC(0, 8, 1, 1).setWeight(1.0, 1.0).setInsets(5, 0, 2, 5));
        jPanel.add((Component)this.setupCheckBox(this.showDiscrepantBox, "Discrepant Obs", this.getShowDiscrepant(), "Toggle to show discrepant observations"), new GBC(0, 9, 1, 1).setWeight(1.0, 1.0).setInsets(0, 0, 2, 5));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.setupTextField(this.starnameReadout, "Star name"), new GBC(0, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.jdReadout, "JD"), new GBC(1, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.fainterthanReadout, "Fainterthan (<)"), new GBC(2, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.magnitudeReadout, "Magnitude"), new GBC(3, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.uncertainReadout, "Uncertain (:)"), new GBC(4, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.uncertaintyReadout, "Uncertainty or error"), new GBC(5, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.commentcodeReadout, "Commentcode"), new GBC(6, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.obstypeReadout, "Obstype (CCD, PEP, etc.)"), new GBC(7, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.bandReadout, "Band (V, B, R, I, etc.)"), new GBC(8, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        jPanel2.add((Component)this.setupTextField(this.obscodeReadout, "Obscode"), new GBC(9, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(5, 0, 2, 5));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.otherReadout.setEditable(false);
        this.otherReadout.setToolTipText("Other fields");
        this.otherReadout.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.otherReadout);
        this.otherReadout.setEditable(false);
        jPanel3.add((Component)jScrollPane, new GBC(0, 0, 1, 1).setWeight(1.0, 1.0).setFill(1).setInsets(0, 10, 0, 10));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.countReadout = new JTextField(this.db.getTotalCount() + " records from the AID");
        jPanel4.add((Component)this.setupTextField(this.dateReadout, "Calendar date of cursor position"), new GBC(0, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 0, 0));
        jPanel4.add((Component)this.setupTextField(this.juliandateReadout, "JD of cursor position"), new GBC(1, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 0, 0));
        jPanel4.add((Component)this.setupTextField(this.magReadout, "Magnitude of cursor position"), new GBC(2, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 0, 0));
        jPanel4.add((Component)this.setupTextField(this.countReadout, "Total number of observations loaded (includes discrepants)"), new GBC(3, 0, 1, 1).setWeight(1.0, 1.0).setFill(2).setInsets(0, 0, 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)this.createPlotPanel(), new GBC(0, 0, 1, 1).setWeight(1.0, 1.0).setFill(1).setInsets(0, 0, 0, 0));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)jMenuBar, new GBC(0, 0, 2, 1).setWeight(0.2, 0.2).setFill(2).setAnchor(18));
        jPanel6.add((Component)jPanel5, new GBC(0, 1, 1, 1).setWeight(1.0, 1.0).setFill(1));
        jPanel6.add((Component)jPanel, new GBC(1, 1, 1, 1).setWeight(0.1, 0.1).setFill(2).setAnchor(13));
        jPanel6.add((Component)jPanel2, new GBC(0, 2, 2, 1).setWeight(0.1, 0.1).setFill(2).setAnchor(17));
        jPanel6.add((Component)jPanel3, new GBC(0, 3, 2, 1).setWeight(0.1, 0.1).setFill(2).setAnchor(17));
        jPanel6.add((Component)jPanel4, new GBC(0, 4, 2, 1).setWeight(0.1, 0.1).setFill(2).setAnchor(15));
        this.add(jPanel6);
        this.validate();
    }

    private JButton setupButton(JButton jButton, String string) {
        jButton.addActionListener(this);
        jButton.setToolTipText(string);
        return jButton;
    }

    public JTextField setupTextField(JTextField jTextField, String string) {
        jTextField.setEditable(false);
        jTextField.setToolTipText(string);
        jTextField.setBackground(Color.WHITE);
        return jTextField;
    }

    public JCheckBox setupCheckBox(JCheckBox jCheckBox, String string, Boolean bl, String string2) {
        jCheckBox.setText(string);
        jCheckBox.addActionListener(this);
        if (bl != null) {
            jCheckBox.setSelected(bl);
        }
        jCheckBox.setToolTipText(string2);
        return jCheckBox;
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        this.chart = ChartFactory.createScatterPlot(null, "Julian Date", "Magnitude", xYDataset, PlotOrientation.VERTICAL, false, false, false);
        this.chart.setBorderVisible(false);
        this.plot = (XYPlot)this.chart.getPlot();
        this.setPreferredColors();
        this.plot.setDomainGridlinesVisible(false);
        this.plot.setRangeGridlinesVisible(false);
        this.plot.setDomainCrosshairVisible(true);
        this.plot.setRangeCrosshairVisible(true);
        this.mainTitle = new TextTitle(this.getMainTitle(), new Font("Ariel", 1, 14));
        this.subTitle = new TextTitle(this.getSubTitle(), new Font("Ariel", 0, 11));
        this.chart.addSubtitle(this.mainTitle);
        this.chart.addSubtitle(this.subTitle);
        this.chart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.legend = new LegendTitle(this.chart.getPlot());
        BlockContainer blockContainer = new BlockContainer(new BorderArrangement());
        BlockContainer blockContainer2 = this.legend.getItemContainer();
        blockContainer2.setPadding(2.0, 1.0, 5.0, 2.0);
        blockContainer.add(blockContainer2);
        this.legend.setWrapper(blockContainer);
        this.legend.setPosition(RectangleEdge.LEFT);
        this.legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
        this.legend.setItemFont(new Font("Ariel", 0, 10));
        this.legend.setBackgroundPaint(this.getPlotColor(this.getBgIndex()));
        this.legend.setItemPaint(this.getPlotColor(this.getChIndex()));
        this.chart.addSubtitle(this.legend);
        NumberAxis numberAxis = (NumberAxis)this.chart.getXYPlot().getDomainAxis();
        NumberAxis numberAxis2 = (NumberAxis)this.chart.getXYPlot().getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis2.setAutoRangeIncludesZero(false);
        numberAxis2.setInverted(true);
        return this.chart;
    }

    public ChartPanel createPlotPanel() {
        this.chart = this.createChart(this.db);
        this.chart.addProgressListener(this);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.addChartMouseListener(this);
        this.chartPanel.addMouseListener(this);
        this.chartPanel.addMouseMotionListener(this);
        this.chartPanel.addFocusListener(this);
        this.chartPanel.requestFocusInWindow();
        this.chartPanel.addKeyListener(this);
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
        this.chartPanel.setFillZoomRectangle(true);
        this.chartPanel.setPreferredSize(new Dimension((int)(this.dim.getHeight() * PLOT_WDTH_FACTOR), (int)(this.dim.getHeight() * PLOT_HT_FACTOR)));
        this.chartPanel.setPopupMenu(null);
        return this.chartPanel;
    }

    public void setPreferredColors() {
        this.plot.setBackgroundPaint(this.getPlotColor(this.getBgIndex()));
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, true);
        int n = this.db.getBandCount();
        int n2 = this.db.getBandCount() + 1;
        int n3 = this.db.getBandCount() + 2;
        for (int i = 0; i < n; ++i) {
            xYLineAndShapeRenderer.setSeriesShape(i, new Rectangle2D.Double(-0.5, -0.5, this.getDotsize(), this.getDotsize()));
            xYLineAndShapeRenderer.setSeriesPaint(i, this.getPlotColor(i));
            xYLineAndShapeRenderer.setSeriesLinesVisible(i, false);
            xYLineAndShapeRenderer.setSeriesShapesVisible(i, true);
            xYLineAndShapeRenderer.setSeriesVisible(i, (Boolean)false);
            for (int j = 0; j < this.db.getNumberOfBandsUsed(); ++j) {
                if (this.db.getBandCode(i) != this.db.getLegendBand(j)) continue;
                xYLineAndShapeRenderer.setSeriesVisible(i, (Boolean)true);
            }
        }
        xYLineAndShapeRenderer.setSeriesShape(n, ShapeUtilities.createDownTriangle(this.getDotsize()));
        xYLineAndShapeRenderer.setSeriesPaint(n, this.getPlotColor(n));
        xYLineAndShapeRenderer.setSeriesOutlinePaint(n, null);
        xYLineAndShapeRenderer.setSeriesShapesVisible(n, true);
        xYLineAndShapeRenderer.setSeriesLinesVisible(n, false);
        xYLineAndShapeRenderer.setSeriesVisible(n, (Boolean)true);
        xYLineAndShapeRenderer.setSeriesShape(n2, ShapeUtilities.createDiagonalCross(this.getDotsize(), 0.25f));
        xYLineAndShapeRenderer.setSeriesPaint(n2, this.getPlotColor(n2));
        xYLineAndShapeRenderer.setSeriesOutlinePaint(n2, null);
        xYLineAndShapeRenderer.setSeriesShapesVisible(n2, true);
        xYLineAndShapeRenderer.setSeriesLinesVisible(n2, false);
        if (!this.getShowDiscrepant().booleanValue()) {
            xYLineAndShapeRenderer.setSeriesVisible(n2, (Boolean)false);
        }
        if (this.db.getShowObs().booleanValue()) {
            xYLineAndShapeRenderer.setSeriesShape(n3, ShapeUtilities.createTranslatedShape(ShapeUtilities.createDiamond(this.getDotsize() + 5), 0.0, 0.0));
            xYLineAndShapeRenderer.setSeriesPaint(n3, Color.WHITE);
            xYLineAndShapeRenderer.setSeriesShapesFilled(n3, false);
            xYLineAndShapeRenderer.setSeriesShapesVisible(n3, true);
            xYLineAndShapeRenderer.setSeriesLinesVisible(n3, false);
            xYLineAndShapeRenderer.setSeriesVisible(n3, (Boolean)true);
        } else {
            xYLineAndShapeRenderer.setSeriesVisible(n3, (Boolean)false);
        }
        this.plot.setDomainCrosshairPaint(this.getPlotColor(this.getChIndex()));
        this.plot.setRangeCrosshairPaint(this.getPlotColor(this.getChIndex()));
        this.plot.setRenderer(xYLineAndShapeRenderer);
        if (this.legend != null) {
            this.legend.setBackgroundPaint(this.getPlotColor(this.getBgIndex()));
            this.legend.setItemPaint(this.getPlotColor(this.getChIndex()));
        }
    }

    @Override
    public void chartProgress(ChartProgressEvent chartProgressEvent) {
        if (chartProgressEvent.getType() != 2) {
            return;
        }
        if (chartProgressEvent.getType() == 2) {
            this.chart = this.chartPanel.getChart();
            if (this.chart != null & this.db.isDataLoadFinished() == true) {
                Runnable runnable;
                this.db.setProgressVisibility(false);
                if (this.mouseClicked.booleanValue()) {
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            Zapper.this.getCrosshairPosition();
                            Zapper.this.displayData(Zapper.this.recordNumber);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                if (this.rightMouseClicked.booleanValue()) {
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            Zapper.this.acknowledgeAndSend();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    this.rightMouseClicked = false;
                }
                this.mouseClicked = false;
            }
        }
    }

    public void acknowledgeAndSend() {
        String string = null;
        Observation observation = this.data.get(this.recordNumber);
        if (!observation.getValflag().equals("T")) {
            string = JOptionPane.showInputDialog(frame, "Click \"OK\" to send selected observation to HQ   \nAdd comment (if desired):", "Send Observation?", 3);
            while (string != null && string.length() > 100) {
                string = JOptionPane.showInputDialog(frame, "Comments are limited to 100 characters, please re-enter:  ", "Invalid Comment", 2);
            }
            while (string != null && !this.validateText(this.removeSpaces(string))) {
                string = JOptionPane.showInputDialog(frame, "This comment contains illegal characters, please re-enter:  ", "Invalid Comment", 2);
            }
            this.db.setEditorComments(this.recordNumber, string);
            if (string != null) {
                this.toggleRecord(this.dupsArray);
            }
        } else {
            this.toggleRecord(this.dupsArray);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n;
        if (actionEvent.getSource() == this.resetButton) {
            if (this.zoomlevel <= 1) {
                this.chartPanel.restoreAutoBounds();
                this.zoomlevel = 0;
            } else {
                --this.zoomlevel;
                this.dAxis.setUpperBound(this.domainUB[this.zoomlevel]);
                this.dAxis.setLowerBound(this.domainLB[this.zoomlevel]);
                this.rAxis.setUpperBound(this.rangeUB[this.zoomlevel]);
                this.rAxis.setLowerBound(this.rangeLB[this.zoomlevel]);
            }
        }
        if (actionEvent.getSource() == this.backButton) {
            this.dAxis = this.plot.getDomainAxis();
            this.dAxis.centerRange(this.dAxis.getLowerBound());
            this.domainUB[this.zoomlevel] = this.dAxis.getUpperBound();
            this.domainLB[this.zoomlevel] = this.dAxis.getLowerBound();
        }
        if (actionEvent.getSource() == this.forwardButton) {
            this.dAxis = this.plot.getDomainAxis();
            this.dAxis.centerRange(this.dAxis.getUpperBound());
            this.domainUB[this.zoomlevel] = this.dAxis.getUpperBound();
            this.domainLB[this.zoomlevel] = this.dAxis.getLowerBound();
        }
        if (actionEvent.getSource() == this.connectMeButton) {
            if (this.db.getShowMyObs().booleanValue()) {
                this.connectMeButton.setText("Show My Obs");
                this.connectButton.setEnabled(true);
                this.db.setShowMyObs(false);
                this.db.setShowObs(false);
                this.db.setObserverToFlag(null);
                for (n = 0; n < this.db.getTotalCount(); ++n) {
                    object = this.data.get(n);
                    this.db.updateSeriesNumber(n, ((Observation)object).getSeries());
                }
                this.setPreferredColors();
                this.db.datasetChanged();
            } else {
                this.connectMeButton.setText("Hide My Obs");
                if (this.db.getEditorObscode() == null || this.db.getEditorObscode().equals("")) {
                    JOptionPane.showMessageDialog(null, "You do not have an observer code.", "No Observer Code", 1);
                    this.connectMeButton.setText("Show My Obs");
                    this.db.setShowMyObs(false);
                    this.connectButton.setEnabled(true);
                } else {
                    this.db.setObserverToFlag(this.db.getEditorObscode());
                    this.db.setShowMyObs(true);
                    this.db.setShowObs(true);
                    this.connectButton.setEnabled(false);
                    this.checkForSelectedObserver(this.db.getObserverToFlag());
                }
            }
        }
        if (actionEvent.getSource() == this.connectButton) {
            if (this.db.getShowObs().booleanValue()) {
                this.connectButton.setText("Show Observer");
                this.connectMeButton.setEnabled(true);
                this.connectButton.setEnabled(true);
                this.db.setShowObs(false);
                this.db.setShowMyObs(false);
                this.db.setObserverToFlag(null);
                this.db.setPreviousObserverToFlag(null);
                for (n = 0; n < this.db.getTotalCount(); ++n) {
                    object = this.data.get(n);
                    this.db.updateSeriesNumber(n, ((Observation)object).getSeries());
                }
                this.setPreferredColors();
                this.db.datasetChanged();
            } else {
                this.connectButton.setText("Hide Observer");
                this.connectMeButton.setEnabled(false);
                this.getCrosshairPosition();
                Observation observation = this.data.get(this.recordNumber);
                object = observation.getObscode() != null && this.recordNumber != 0 ? observation.getObscode() : (this.db.getObserverToFlag() != null ? this.db.getObserverToFlag() : "");
                String string = JOptionPane.showInputDialog(frame, "Please type observer's initials:", object);
                if (string != null) {
                    this.db.setObserverToFlag(string.toUpperCase());
                    this.db.setBandToConnect(observation.getBand());
                    this.db.setShowObs(true);
                    this.checkForSelectedObserver(this.db.getObserverToFlag());
                } else {
                    this.connectButton.setText("Show Observer");
                    this.connectMeButton.setEnabled(true);
                    this.db.setShowObs(false);
                    this.db.setObserverToFlag(null);
                    this.db.setPreviousObserverToFlag(null);
                }
            }
        }
        if (actionEvent.getSource() == this.nextstarButton) {
            this.db.setPreviousObserverToFlag(this.db.getObserverToFlag());
            this.db.setObserverToFlag(null);
            this.db.plotNextStar(this.db.getStar(), true);
        }
        if (actionEvent.getSource() == this.showDiscrepantBox) {
            this.showDiscrepantOrNot();
        }
        if (actionEvent.getSource() == this.colorOption) {
            this.setSavedColor(this.plotColor);
            this.colors = new ColorSelector(this, this.db, this.plotColor, this.getColorArraySize());
        }
        if (actionEvent.getSource() == this.biggerDotsOption) {
            this.setDotsize(this.getDotsize() + 1);
            this.setUserDefaults(this.getColorArray());
            this.setPreferredColors();
        }
        if (actionEvent.getSource() == this.smallerDotsOption && this.getDotsize() > 1) {
            this.setDotsize(this.getDotsize() - 1);
            this.setUserDefaults(this.getColorArray());
            this.setPreferredColors();
        }
        if (actionEvent.getSource() == this.legendOption) {
            if (this.chart.getLegend() != null) {
                this.chart.removeLegend();
                this.chart.setBackgroundImage(null);
                this.legendOption.setText("Show Legend");
            } else {
                this.chart.addLegend(this.legend);
                this.chart.setBackgroundImage(this.logo);
                this.legendOption.setText("Hide Legend");
            }
        }
        if (actionEvent.getSource() == this.printOption) {
            this.chartPanel.createChartPrintJob();
        }
        if (actionEvent.getSource() == this.savePlotOption) {
            try {
                this.chartPanel.doSaveAs();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (actionEvent.getSource() == this.onlineHelp) {
            try {
                String string = "https://www.aavso.org/files/software/zapper/Zapperhelp.shtml";
                object = new Hyperlink(string);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(null, "MalformedURLException: " + malformedURLException.getMessage(), "Warning", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Exception: " + exception.getMessage(), "Warning", 0);
            }
        }
        if (actionEvent.getSource() == this.aboutHelp) {
            JOptionPane.showMessageDialog(null, "Zapper Version V4.1\n (December 8, 2017)\n\nAuthor: Sara J. Beck, AAVSO Technical Staff\nContact: sara@aavso.org or aavso@aavso.org", "About Zapper...", -1);
        }
        if (actionEvent.getSource() == this.quitButton) {
            this.setUserDefaults(this.getColorArray());
            System.exit(0);
        }
    }

    public void checkForSelectedObserver(String string) {
        int n = 0;
        if (string != null) {
            this.db.setObserverToFlag(string);
            this.db.setShowObs(true);
            this.db.setShowMyObs(true);
            for (int i = 0; i < this.db.getTotalCount(); ++i) {
                Observation observation = this.data.get(i);
                if (!this.getShowDiscrepant().booleanValue() && observation.getValflag().equals("T") || !observation.getObscode().equals(string)) continue;
                this.db.setObserverToFlag(string);
                this.db.updateSeriesNumber(i, observation.getSeries());
                ++n;
            }
            if (n == 0) {
                JOptionPane.showMessageDialog(null, "Our records show that " + string + " has no observations\nfor this star during the period selected.", "No Observations", 1);
                this.connectMeButton.setText("Show My Obs");
                this.connectButton.setText("Show Observer");
                this.db.setShowMyObs(false);
                this.db.setShowObs(false);
                this.connectButton.setEnabled(true);
                this.connectMeButton.setEnabled(true);
                this.db.setObserverToFlag(null);
            } else {
                this.setPreferredColors();
                this.db.datasetChanged();
            }
        }
    }

    public void showDiscrepantOrNot() {
        this.setShowDiscrepant(this.showDiscrepantBox.isSelected());
        if (this.getShowDiscrepant().booleanValue()) {
            for (int i = 0; i < this.db.getTotalCount(); ++i) {
                Observation observation = this.data.get(i);
                if (observation.getValflag().equals("T")) {
                    this.db.updateSeriesNumber(i, observation.getSeries());
                }
                this.db.setPlotAxes(observation, observation.getSeries(), i);
            }
        } else {
            for (int i = 0; i < this.db.getTotalCount(); ++i) {
                Observation observation = this.data.get(i);
                if (observation.getValflag().equals("T")) continue;
                this.db.setPlotAxes(observation, observation.getSeries(), i);
            }
        }
        this.setPreferredColors();
        this.db.datasetChanged();
    }

    public void setupNewPlot() {
        if (!this.db.getCancelSelected().booleanValue()) {
            this.countReadout.setText(this.db.getTotalCount() + " records from the AID");
            this.mainTitle.setText(this.getMainTitle());
            this.subTitle.setText(this.getSubTitle());
            this.chartPanel.restoreAutoBounds();
            this.zoomlevel = 0;
            this.checkForSelectedObserver(this.db.getPreviousObserverToFlag());
            this.showDiscrepantOrNot();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
        this.chartPanel.requestFocus();
        if (chartMouseEvent.getTrigger().getButton() == 1 && this.getControlPressed().booleanValue()) {
            this.rightMouseClicked = true;
            this.mouseClicked = true;
            this.setControlPressed(false);
        } else if (chartMouseEvent.getTrigger().getButton() == 1) {
            this.leftMouseClicked = true;
            this.mouseClicked = true;
        } else if (chartMouseEvent.getTrigger().getButton() == 3) {
            this.rightMouseClicked = true;
            this.mouseClicked = true;
        }
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        this.chartPanel.requestFocus();
        int n = chartMouseEvent.getTrigger().getX();
        int n2 = chartMouseEvent.getTrigger().getY();
        Point2D point2D = this.chartPanel.translateScreenToJava2D(new Point(n, n2));
        XYPlot xYPlot = (XYPlot)this.chartPanel.getChart().getPlot();
        ChartRenderingInfo chartRenderingInfo = this.chartPanel.getChartRenderingInfo();
        Rectangle2D rectangle2D = chartRenderingInfo.getPlotInfo().getDataArea();
        double d = xYPlot.getDomainAxis().java2DToValue(point2D.getX(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = xYPlot.getRangeAxis().java2DToValue(point2D.getY(), rectangle2D, xYPlot.getRangeAxisEdge());
        this.juliandateReadout.setText("JD = " + this.jdFormat.format(d));
        this.magReadout.setText("mag = " + this.magFormat.format(d2));
        this.dateReadout.setText(this.date.jdToCalendar(d));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            this.setControlPressed(true);
        }
        if (keyEvent.getKeyCode() == 39) {
            this.dAxis = this.plot.getDomainAxis();
            this.dAxis.centerRange(this.dAxis.getUpperBound());
            this.domainUB[this.zoomlevel] = this.dAxis.getUpperBound();
            this.domainLB[this.zoomlevel] = this.dAxis.getLowerBound();
        }
        if (keyEvent.getKeyCode() == 37) {
            this.dAxis = this.plot.getDomainAxis();
            this.dAxis.centerRange(this.dAxis.getLowerBound());
            this.domainUB[this.zoomlevel] = this.dAxis.getUpperBound();
            this.domainLB[this.zoomlevel] = this.dAxis.getLowerBound();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            this.setControlPressed(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragged = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseDragged.booleanValue()) {
            ++this.zoomlevel;
            if (this.zoomlevel == 10) {
                this.zoomlevel = 9;
            }
            this.dAxis = this.plot.getDomainAxis();
            this.rAxis = this.plot.getRangeAxis();
            this.domainUB[this.zoomlevel] = this.dAxis.getUpperBound();
            this.domainLB[this.zoomlevel] = this.dAxis.getLowerBound();
            this.rangeUB[this.zoomlevel] = this.rAxis.getUpperBound();
            this.rangeLB[this.zoomlevel] = this.rAxis.getLowerBound();
            this.mouseDragged = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static String addLabel(String string, String string2) {
        if (string != null && !string.equals("") && !string.equals("0")) {
            return string2 + string + " ";
        }
        return "";
    }

    public void displayData(int n) {
        Observation observation = this.data.get(n);
        this.designationReadout.setText(observation.getDesignation());
        this.starnameReadout.setText(observation.getName());
        this.jdReadout.setText("" + observation.getJD());
        this.fainterthanReadout.setText(this.db.getFainterthanString(observation.getFainterthan()));
        this.magnitudeReadout.setText("" + observation.getMagnitude());
        this.uncertainReadout.setText(this.db.getUncertainString(observation.getUncertain()));
        this.commentcodeReadout.setText(observation.getCommentcode());
        this.obstypeReadout.setText(observation.getObstype());
        this.bandReadout.setText(observation.getBandString());
        this.uncertaintyReadout.setText(observation.getUncertainty());
        this.obscodeReadout.setText(observation.getObscode());
        this.otherReadout.setText(" charts: " + this.db.getChartString(observation.getCharts()) + Zapper.addLabel(observation.getComp1_C(), this.comp1_CLabel) + Zapper.addLabel(observation.getCmag(), this.cmagLabel) + Zapper.addLabel(observation.getComp2_K(), this.comp2_KLabel) + Zapper.addLabel(observation.getKmag(), this.kmagLabel) + "\n comments: " + this.db.getCommentString(observation.getComments()) + "\n" + Zapper.addLabel(observation.getMtype(), this.mtypeLabel) + Zapper.addLabel(observation.getGroup(), this.groupLabel) + Zapper.addLabel(observation.getAirmass(), this.airmassLabel) + Zapper.addLabel(this.db.getTransformedString(observation.getTransformed()), this.transformedLabel) + Zapper.addLabel(observation.getSoftware(), this.softwareLabel) + "\n" + Zapper.addLabel(observation.getArrivaldate(), this.arrivaldateLabel) + Zapper.addLabel(observation.getCredit(), this.creditLabel) + "\n" + Zapper.addLabel(observation.getUnique_id() + "", this.unique_idLabel));
    }

    private void toggleRecord(int[] nArray) {
        int n = 1;
        while (nArray[n] != 0) {
            this.recordNumber = nArray[n];
            Observation observation = this.data.get(this.recordNumber);
            this.db.toggleValflag(observation.getValflag(), this.recordNumber, observation.getSeries());
            this.db.logRecord(this.recordNumber);
            ++n;
        }
    }

    public String removeSpaces(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + stringTokenizer.nextElement();
        }
        return string2;
    }

    public boolean validateText(String string) {
        String string2 = "abcdefghijklmnopqrstuvwxyz0123456789+-=&.,?!<>";
        char[] cArray = string.toLowerCase().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (string2.indexOf(cArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    public void setDefaultZapperColors() {
        for (int i = 0; i < this.getColorArraySize() - 5; ++i) {
            this.setPlotColor(i, new Color(this.db.getR_color(i), this.db.getG_color(i), this.db.getB_color(i)));
            if (this.db.getBandCode(i) != 0) continue;
            this.setPlotColor(i, VISCOLOR);
        }
        this.setPlotColor(this.getColorArraySize() - 5, ChartColor.VERY_DARK_MAGENTA);
        this.setPlotColor(this.getColorArraySize() - 4, Color.RED);
        this.setObsIndex(this.getColorArraySize() - 3);
        this.setBgIndex(this.getColorArraySize() - 2);
        this.setChIndex(this.getColorArraySize() - 1);
        this.setPlotColor(this.getObsIndex(), Color.WHITE);
        this.setPlotColor(this.getBgIndex(), BGCOLOR);
        this.setPlotColor(this.getChIndex(), Color.WHITE);
    }

    public void setDefaultLCGColors() {
        for (int i = 0; i < this.getColorArraySize() - 5; ++i) {
            this.setPlotColor(i, new Color(this.db.getR_color(i), this.db.getG_color(i), this.db.getB_color(i)));
        }
        this.setPlotColor(this.getColorArraySize() - 5, ChartColor.VERY_DARK_MAGENTA);
        this.setPlotColor(this.getColorArraySize() - 4, Color.RED);
        this.setObsIndex(this.getColorArraySize() - 3);
        this.setBgIndex(this.getColorArraySize() - 2);
        this.setChIndex(this.getColorArraySize() - 1);
        this.setPlotColor(this.getObsIndex(), BGCOLOR);
        this.setPlotColor(this.getBgIndex(), Color.WHITE);
        this.setPlotColor(this.getChIndex(), BGCOLOR);
    }

    public void getCrosshairPosition() {
        this.crosshairJD = this.plot.getDomainCrosshairValue();
        this.crosshairMag = this.plot.getRangeCrosshairValue();
        this.dupsArray = this.db.getRecordNumbers(this.crosshairJD, this.crosshairMag);
        this.recordNumber = this.dupsArray[1];
        Observation observation = this.data.get(this.recordNumber);
        this.seriesNumber = observation.getSeries();
    }

    public void getUserDefaults() {
        String string = this.db.getPathToFile(this.db.getUserDefaultsFilename());
        try {
            File file = new File(string);
            if (file.exists() && file.canRead()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                bufferedReader.readLine();
                for (int i = 0; i < this.getColorArraySize(); ++i) {
                    this.setPlotColor(i, new Color(Integer.parseInt(bufferedReader.readLine())));
                }
                this.setDrawLines(new Boolean(bufferedReader.readLine()));
                this.setDotsize(Integer.parseInt(bufferedReader.readLine()));
                bufferedReader.close();
            } else {
                this.chart = this.chartPanel.getChart();
                this.setDefaultZapperColors();
                this.setDrawLines(true);
                this.setDotsize(2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "FileNotFoundException: " + fileNotFoundException.getMessage(), "Warning", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException: " + iOException.getMessage(), "Warning", 0);
        }
        catch (Exception exception) {
            this.setDefaultZapperColors();
        }
    }

    public void setUserDefaults(Color[] colorArray) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(this.db.getPathToFile(this.db.getUserDefaultsFilename())));
            printWriter.println(this.db.getEditorName());
            for (int i = 0; i < this.getColorArraySize(); ++i) {
                if (colorArray[i].getRGB() != 0) {
                    printWriter.println(colorArray[i].getRGB());
                    continue;
                }
                printWriter.println(this.getPlotColor(i));
            }
            printWriter.println(this.getDrawLines());
            printWriter.println(this.getDotsize());
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "FileNotFoundException: " + fileNotFoundException.getMessage(), "Warning", 0);
        }
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public Color getPlotColor(int n) {
        return this.plotColor[n];
    }

    public Color getSavedColor(int n) {
        return this.savedColor[n];
    }

    public Color[] getColorArray() {
        return this.plotColor;
    }

    public Boolean getDrawLines() {
        return this.connectObs;
    }

    public Boolean getShowDiscrepant() {
        return this.showDiscrepant;
    }

    public Boolean getControlPressed() {
        return this.controlPressed;
    }

    public int getColorArraySize() {
        return this.colorArraySize;
    }

    public int getDotsize() {
        return this.dotsize;
    }

    public int getBgIndex() {
        return this.bgIndex;
    }

    public int getChIndex() {
        return this.chIndex;
    }

    public int getObsIndex() {
        return this.obsIndex;
    }

    public String getMainTitle() {
        return this.db.getStar() + "   (AUID " + this.db.getAUID() + ")";
    }

    public String getSubTitle() {
        return this.db.getVsxStar() + "   type: " + this.db.getVarType() + "   period: " + this.db.getPeriod() + "   max: " + this.db.getMagMax() + "   min/amplitude: " + this.db.getMagMin() + "   spectral type: " + this.db.getSpecType() + "\nData from the AAVSO International Database - www.aavso.org";
    }

    public String getDrawLinesText() {
        if (this.getDrawLines().booleanValue()) {
            return "Hide connecting lines";
        }
        return "Show connecting lines";
    }

    public void setPlotColor(int n, Color color) {
        this.plotColor[n] = color;
    }

    public void setDrawLines(Boolean bl) {
        this.connectObs = bl;
    }

    public void setShowDiscrepant(Boolean bl) {
        this.showDiscrepant = bl;
    }

    public void setControlPressed(Boolean bl) {
        this.controlPressed = bl;
    }

    public void setColorArraySize(int n) {
        this.colorArraySize = n;
    }

    public void setDotsize(int n) {
        this.dotsize = n;
    }

    public void setBgIndex(int n) {
        this.bgIndex = n;
    }

    public void setChIndex(int n) {
        this.chIndex = n;
    }

    public void setObsIndex(int n) {
        this.obsIndex = n;
    }

    public void setFrameVisibility(Boolean bl) {
        frame.setVisible(bl);
    }

    public void setSavedColor(Color[] colorArray) {
        for (int i = 0; i < this.getColorArraySize(); ++i) {
            this.savedColor[i] = colorArray[i];
        }
    }

    private static void createAndShowGUI() {
        frame = new JFrame("Zapper V4.1 (December 8, 2017)");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(2);
        Zapper zapper = new Zapper();
        zapper.setOpaque(true);
        frame.setContentPane(zapper);
        frame.pack();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Zapper.createAndShowGUI();
            }
        });
    }
}

